<?php

namespace DAO;


/**
 */
class EvaluateGoodsModel extends \DAO\AbstractModel {



    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_evaluate_goods';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'geval_id';

    public function init(){

    }

    public function getOneByWhere($where,$field){
        $this->setDb();
        return $this->db->select($field)->from($this->_tableName)->where($where)->fetchOne();
    }

    public function getList($where,$field,$order,$pageIndex,$pageSize,$haveImg = false){
        $this->setDb();
        if($haveImg){
            return $this->db->select($field)->from($this->_tableName)->where($where)->where("geval_image !='N;'")->order($order[0],$order[1])->page($pageIndex,$pageSize)->fetchAll();
        }
        return $this->db->select($field)->from($this->_tableName)->where($where)->order($order[0],$order[1])->page($pageIndex,$pageSize)->fetchAll();
    }
    public function getCount($where,$haveImg = false){
        $this->setDb();
        if($haveImg){
            return $this->db->from($this->_tableName)->where($where)->where('geval_image is not null')->fetchNum();
        }
        return $this->db->from($this->_tableName)->where($where)->fetchNum();
    }
    public function getEvaluateGoodsCount($where,$isArray = true){
        $this->setDb();
        if(!$isArray){
            $str = '$count =  $this->db->from($this->_tableName)';
            foreach ($where as $v){
                $str .= "->where('$v')";
            }
            $str .= "->fetchNum();";
            eval($str);
            return $count;
        }
        return $this->db->from($this->_tableName)->where($where)->fetchNum();
    }
    public function insertAll($datas){
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        $error = 0;
        $baseSql = "insert IGNORE into {$this->_tableName}(geval_orderid,geval_orderno,geval_ordergoodsid,geval_goodsid,geval_goodsname,geval_goodsprice,geval_goodsimage,geval_scores,geval_content,geval_isanonymous,geval_addtime,geval_storeid,geval_storename,geval_frommemberid,geval_frommembername,geval_image,geval_goods_commonid,goods_spec) values";
        $insertAllSql = $baseSql;
        for ($i = 0; $i < count($datas); $i++) {
            $addSql = \Our\Common::format("('{0}','{1}','{2}','{3}','{4}','{5}','{6}','{7}','{8}','{9}','{10}','{11}','{12}','{13}','{14}','{15}','{16}','{17}'),", $datas[$i]['geval_orderid'], $datas[$i]['geval_orderno'], $datas[$i]['geval_ordergoodsid'], $datas[$i]['geval_goodsid'], $datas[$i]['geval_goodsname'], $datas[$i]['geval_goodsprice'], $datas[$i]['geval_goodsimage'], $datas[$i]['geval_scores'], $datas[$i]['geval_content'], $datas[$i]['geval_isanonymous'], $datas[$i]['geval_addtime'], $datas[$i]['geval_storeid'], $datas[$i]['geval_storename'], $datas[$i]['geval_frommemberid'], $datas[$i]['geval_frommembername'], $datas[$i]['geval_image'],$datas[$i]['geval_goods_commonid'],$datas[$i]['goods_spec']);
            $insertAllSql .= $addSql;
            if ($i % 1000 == 0 && $i != 0) {
                $insertAllSql = rtrim($insertAllSql, ',');
                $one = $this->db->insert($this->_tableName)->query($insertAllSql);
                if (!$one) {
                    $error++;
                }
                $insertAllSql = $baseSql;
            }
        }
        if ($insertAllSql != $baseSql) {
            $insertAllSql = rtrim($insertAllSql, ',');
            $one = $this->db->insert($this->_tableName)->query($insertAllSql);

            if (!$one) {
                $error++;
            }
        }
        if ($error > 0) {
            return false;
        }
        return true;
    }
    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }


}
