<?php
namespace DAO\Adv;

/**
 * 广告位管理
 * User: liuyuzhen
 * Date: 2018/5/28
 * Time: 11:38
 * Description:
 */
class AdvModel extends \DAO\AbstractModel{


    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_adv';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'ap_id';

    public function init(){
    }
    /**
     * 获取固定位置广告位
     */
    public function  getPostionAdv($positionId){
        $this->setDb();
        $condition  = \Our\Common::format("is_allow = {0} and  ap_id = {1} and adv_start_date <{2} and adv_end_date >= {3}",\Our\ApiConst::one,$positionId,TIMESTAMP,TIMESTAMP-\Our\ApiConst::oneDaySecond);
        $advs = $this->db->select('adv_content')->from($this->_tableName)->where($condition)->fetchAll();
        if($advs){
            $result = array();
            foreach($advs as $adv){
                $advContent=unserialize($adv['adv_content']);
                if($advContent['adv_pic_url']){
                    $temp['href']=\Our\NameConst::httpPrefix.$advContent['adv_pic_url'];
                }
                $temp['imageUrl']=\Our\Common::getStaticFile($advContent['adv_pic'],\Our\ImageConst::advPath);
                $result[] = $temp;
            }
            return $result;
        }
        return false;
    }


    /**
     * 类实例
     */
    private static $_instance = null;

    /**
     * 获取类实例
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }
}