<?php

namespace DAO\Order;


use Our\ImageConst;


/**
 * 订单相关
 * @date 2018-5-14
 * @author csw
 */
class RefundReasonModel extends \DAO\AbstractModel
{


    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_refund_reason';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'id';

    public function init()
    {
        //$this->setDb();
    }


    public function getCount($where, $isArray = true)
    {
        $this->setDb();
        if (!$isArray) {
            $str = '$count =  $this->db->from($this->_tableName)';
            foreach ($where as $v) {
                $str .= "->where('$v')";
            }
            $str .= "->fetchNum();";
            eval($str);
            return $count;
        }
        return $this->db->from($this->_tableName)->where($where)->fetchNum();
    }

    /**
     * 获取单条数据
     * @param $where
     * @return array
     */
    public function find($where)
    {
        $data = $this->db->from($this->_tableName)->where($where)->fetchOne();
        return $data;
    }

    public function findById($id)
    {
        $where[$this->_primaryKey] = $id;
        return $this->find($where);
    }

    public function convert($info,$keyValues,$imageField='qrcode_path'){
        $convertInfo=array();
        foreach($keyValues as $key =>$val){
            if($key!=$imageField){
                $convertInfo[$val]=$info[$key];
            }else{
                $convertInfo[$val]=\Our\Common::getStaticFile($info[$key],ImageConst::memberAvatar) ;
            }
        }
        return $convertInfo;
    }

    public function getAll($fields='*'){
        $this->setDb($this->dbName);
        $list = $this->db->from($this->_tableName)->select($fields)->fetchAll();
        return $list;
    }

   public function convertToKey($refundReasons){

       $convertRefundReasons=array();
       foreach($refundReasons as $refundReason){
           $convertRefundReasons[$refundReason['reasonId']]=$refundReason;
       }
       return $convertRefundReasons;
   }
    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;


    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance($dbName=\Our\DbNameConst::salveDBConnectName)
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }

}
