<?php
namespace Our;
/**
 * User: liuyuzhen
 * Date: 2018/5/16
 * Time: 20:00
 * Description:
 */
class Validate{

    /**
     * 获取指定长度的数字字符串
     * @param int $length 所需字符串长度
     * @return string
     */
    public static function getNumberString($length=6){
        $numberStr = '';

        $numArray= array(0,1,2,3,4,5,6,7,8,9);
        for($i=0;$i<$length;$i++){
            $keys = array_rand($numArray,1);
            $numberStr .= $numArray[$keys];
        }
        return $numberStr;
    }

    /**
     * 验证数字字符串
     * @param $value
     * @param int $length
     * @return bool
     */
    public static function validNumberStr($value,$length = 6){

        if( !preg_match('/^\d{'.$length.'}$/', $value) ){
            return false;
        }
        return true;
    }


    /**
     * 验证电话号码是否为座机
     * @param $phone
     * @return bool
     */
    public static function checkTelePhone($phone){
        if( empty($phone) ){
            return false;
        }

        if( !preg_match('/^(0\d{2,3}-?)?\d{7,8}$/', $phone) ){
            return false;
        }

        return true;
    }

    /**
     * @param $str 需要验证的字符串
     * @param $min 最小长度
     * @param $max 最大长度
     * @return bool 是否在长度范围内
     */
    public static function checkLengthRange($str,$min,$max){
        $strlen = strlen($str);

        if($strlen<$min||$strlen>=$max){
            return false;
        }
        return true;
    }

    /**
     * 检查日期字符串是否合法
     * @param $date
     * @return bool
     */
    public static function checkDateStr($date){

        $reg = '/^(?:(?!0000)[0-9]{4}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)$/';
        if( !preg_match($reg, $date) ){
            return false;
        }
        return true;
    }


    public static function checkPassword($password){
        if(!$password){
            return false;
        }
        if(preg_match("/^(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{6,12}$/",$password)){
            return true;
        }
        return false;
    }

}