<?php

namespace DAO\Store;

class QmStoreApplyClassModel extends \DAO\AbstractModel
{


    

    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_qm_store_apply_class';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'id';

    public function init()
    {
    }


    public function getList($where,$field)
    {
        $this->setDb();
        $data = $this->db->select($field)->from($this->_tableName)->where($where)->fetchAll();
        return $data;
    }

    public function getListByStoreId($storeId,$field) {
        $where['store_id'] = $storeId;
        return $this->getList($where,$field);
    }

    public function getApplyPicCache($storeId,$field) {
        return \Our\RedisHelper::cachedFunction(\Redis\Db6\StoreRedisModel::getInstance(),array(&$this, 'getApplyPic'),array($storeId,$field),\Our\ApiConst::oneDaySecond,array($storeId));
    }
    public function getApplyPic($storeId, $field) {
        $list = $this->getListByStoreId($storeId,$field);
        $pics = [];
        if($list) {
            foreach ($list as $v) {
                if($file_name = unserialize($v['file_name'])) {
                    if(in_array(substr(strrchr($file_name,'.'),1),\Our\ArrayConst::imageExtensions)){
                        $pics[] =\Our\Common::getStaticFile($file_name, \Our\ImageConst::Register, 'ossHost');
                    }
                }
            }
        }
        return $pics;
    }
    public function addWaterMark($pics,$filename = 'watermark.png?x-oss-process=image/resize,P_30') {
        $waterPics = [];
        if(is_array($pics) && $pics) {
            $position = ['g_se','g_nw','g_south','g_north','g_sw','g_ne','g_east','g_west','g_center'];
            $pic = base64_encode($filename);
            $str = '?x-oss-process=image/resize,w_400';
            for($i = 0 ; $i < count($position); $i++) {
                $str .= sprintf('/watermark,image_%s,t_90,%s,x_10,y_10',$pic,$position[$i]);
            }
            foreach ($pics as $v) {
                $waterPics[] = $v.$str;
            }
        }
        return $waterPics;
    }
    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance()
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

}
