<?php
namespace Business\Common;

use Mysql\MbUserTokenModel;
use Our\ApiConst;
use Our\Common;
use Our\ImageConst;
use Our\ImageUtil;

/**
 * User: liuyuzhen
 * Date: 2018/6/14
 * Time: 13:41
 * Description:
 */
class CommonServiceModel extends \Business\AbstractModel
{


    /**
     * 删除用户信息
     * @param $data
     */
    public function delMember($data)
    {
        $memberDao = \DAO\MemberModel::getInstance();
        $memberDao->checkDelMember($data);
        $existMember = $memberDao->getOneByWhereWithField(array('member_mobile' => $data['mobile']), 'member_id');
        if (empty($existMember)) {
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyMemberForDelMember);
        }
        $memberId = $existMember['member_id'];
        $mbUserTokenModel = \DAO\MbUserTokenModel::getInstance();
        $mbUserTokenModel->del($existMember);
        $storeMemberModel = \DAO\StoreMemberModel::getInstance();
        $storeMemberModel->del($existMember);
        $memberDeviceInfoModel = \DAO\MemberDeviceInfoModel::getInstance();
        $memberDeviceInfoModel->del($existMember);
        $memberMappingModel = \DAO\MemberMappingModel::getInstance();
        $memberMappingModel->del($existMember);
        $result = $memberDao->del($existMember);
        if ($result) {
            $memberRedisModel = \Redis\Db0\MemberRedisModel::getInstance();
            $memberRedisModel->tableDel($memberId);
        }
        return $result;
    }

    private function saveWxImage($data)
    {
        $fileName = $data['image'];
        if (!empty($_FILES[$fileName]['tmp_name'])) {
            $savePath = ImageConst::uploadTypes[$data['type']];
            $res = ImageUtil::uploadImage($_FILES[$fileName]['tmp_name'], $savePath, ImageUtil::getFileName($data['type']));
            $fileName = basename($res);
            return array(
                'fileName' => $fileName,
                'url' => $res
            );

        }
        return new \stdClass();


    }

    public function saveImage($data)
    {
        if (!$data['image']) {
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyImageStr);
        }
        if ($data['type'] && in_array($data['type'], array_keys(\Our\ImageConst::uploadTypes))) {
            $path = \Our\ImageConst::uploadTypes[$data['type']];
        } else {
            $path = \Our\ImageConst::defaultPath;
        }
        //如过是微信
        $requstDriver = Common::getDriverType();
        if ($requstDriver == ApiConst::wxType||(isset($data['name'])&&!empty($data['name']))) {
            return $this->saveWxImage($data);
        }
        $time = date('YmdHis_');
        $fileName = $time . \Our\Validate::getNumberString();
        $fileUrl = \Our\ImageUtil::uploadBase64Image($data['image'], $path, $fileName);
        if (!$fileUrl) {
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::imageUploadFailed);
        }
        return array(
            'fileName' => $fileName,
            'url' => $fileUrl
        );
    }

    /**
     * @param $type 1:平台 2:店铺 3:商品
     * @param int $id
     * @param string $shareDesc
     * @return mixed
     */
    public function getShareInfo($type, $id = 0, $shareDesc = '')
    {
        $id = (int)$id;
        if ($type == \Our\ApiConst::sharePlat) {
            $share = \DAO\SettingModel::getInstance()->getShareInfo();
        } elseif ($type == \Our\ApiConst::shareStore) {
            $share = \DAO\StoreModel::getInstance()->getShareInfo($id);
        } elseif ($type == \Our\ApiConst::shareGoods) {
            $share = \DAO\GoodsCommonModel::getInstance()->getShareInfo($id, $shareDesc);
        }
        return $share;
    }

    private static $_instance = null;

    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance()
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }
}