<?php
namespace DAO;
use  Elasticsearch\ClientBuilder;
use Error\CodeConfigModel;
use Error\ErrorModel;
use Our\NameConst;

/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/8/17
 * Time: 15:11
 */
class ElasticsTool{
    protected $dbName;
    protected $tbName;
    protected $client;
    protected function __construct($dbName,$tbName)
    {
        $elasticConfig=\Our\Common::getConfig(NameConst::elasticName);
        $configArray=array(
            'host' => $elasticConfig->host,
            'port' => $elasticConfig->port,
            'scheme' => $elasticConfig->scheme
        );
        try{
            $this->dbName=$dbName;
            $this->tbName=$tbName;
            $this->client =ClientBuilder::create()->setHosts($configArray)->build();
        }catch(\Exception $e){
            ErrorModel::throwException(CodeConfigModel::elasticsError);
        }
    }
    protected function initParams(){
        return [
            'index'=>$this->dbName,
            'type'=>$this->tbName
        ];
    }
    /*
     * 陈传文
     * 创建索引在设置mapping之前要创建索引
     *
     *
     *
     * */
    public function createIndex(){
        try{
            $indexParams=[
                'index'=>$this->dbName,
            ];
            $r=$this->client->indices()->create($indexParams);
        }catch(\Exception $e){
            ErrorModel::throwException(CodeConfigModel::elasticsError);
        }
    }

}