<?php

/**
 * 关闭订单
 * 执行时间：每分钟执行一次
 *
 * @author chenjiebin <sjlinyu@qq.com>
 */

define("APPLICATION_PATH", realpath(dirname(__FILE__) . '/../../../')); //指向public的上一级
require APPLICATION_PATH . '/scripts/crontab/baseCli.php';
require APPLICATION_PATH . '/scripts/crontab/common.php';
error_reporting(E_ALL ^ E_NOTICE);

class cliShopkeeperIndex extends basecli
{
    const CLI_ADMIN_ID = 255;
    private $bDoUnLock = FALSE;   // 是否允许释放 LOCK 文件
    private $_debug = 0;
    private $lockFileName;
    private $fromState;

    private function mkdirs($dir, $mode = 0777)
    {
        if (is_dir($dir) || @mkdir($dir, $mode)) {
            return TRUE;
        }
        if (!$this->mkdirs(dirname($dir), $mode)) {
            return FALSE;
        }
        return @mkdir($dir, $mode);
    }

    /**
     * 析构
     */
    public function __destruct()
    {
        parent::__destruct();
        if ($this->bDoUnLock) {
            @unlink($this->lockFileName);

        }
    }

    protected function _runCli()
    {
        $this->_debug = isset($this->aArgv[1]) ? intval($this->aArgv[1]) : 0;
        if ($this->_debug) {
            echo "*** Debug mode ***\n";
        }
        // Step: 02 检查是否已有相同CLI在运行中
        $lockDir = $this->_getBaseFileName('shopkeeper');
        if (!$this->mkdirs($lockDir)) {
            echo '****create dir fail  ****';
            exit;
        }
        $this->lockFileName = $lockDir . DS . 'index.locks';
        if (file_exists($this->lockFileName)) {
            $stat = stat($this->lockFileName);
            if ((TIMESTAMP - $stat['mtime']) > 1800) {
                echo "文件被锁超过1800秒，被强制删除";
                @unlink($this->lockFileName);
            } else {
                $this->halt('[' . date('Y-m-d H:i:s') . '] The CLI is running' . "\n");
            }
        }
        $this->bDoUnLock = true;
        file_put_contents($this->lockFileName, "running"); // CLI 独占锁
        $shopkeeperService = \Business\Store\ShopkeeperServiceModel::getInstance();
        $shopkeeperService->baseDir= \Our\Common::getConfig('out.config');
        try {

            $shopkeeperService->insertStoreMemberStatics();
            //退货退款订单自动关闭
            $shopkeeperService->reduceStoreMemberStatics();
           // $shopkeeperService->storeStatictisTask();
          //  $shopkeeperService->updateLastId();
        } catch (Exception $ex) {
            throw new Exception($ex->getCode() . '|' . $ex->getMessage());
        }
        echo 'store static insert success' .date('Y-m-d H:i:s',TIMESTAMP). "\r\n";
    }
}

$oCli = new cliShopkeeperIndex(TRUE);

EXIT;
?>
