<?php

class DeliveryController extends \Our\Controller_AbstractApi {


    /**
     * 获取订单列表
     *
     * @ccw
     */

    public function getOrdersAction(){
        $orderService=\Business\Order\OrderServiceModel::getInstance();
        $pageIndex=$this->getPageIndex();
        $pageSize=$this->getPageSize();
        if(isset($this->req[\Our\NameConst::data]['type'])&& !empty($this->req[\Our\NameConst::data]['type'])){
            $type=$this->req[\Our\NameConst::data]['type'];
        }else{
            $type=\Our\ApiConst::orderTypeBuy;
        }
        $deliveryOrders=$orderService->getQmDeliveryLogList($this->memberId,$type,$pageIndex,$pageSize);
        $this->success($deliveryOrders);

    }
    /**
     * 取消订单
     *
     * @ccw
     */

    public function cancelAction(){
        $orderService=\Business\Order\OrderServiceModel::getInstance();
        $orderService->cancel($this->req[\Our\NameConst::data]['orderId']);
        $this->success(new \stdClass(),\Our\DescribeConst::cancelOrderSuccess);
    }

    /**
     * 确认收货
     *
     * @ccw
     */

    public function recieveAction(){
        $orderService=\Business\Order\OrderServiceModel::getInstance();
        $orderService->confirmRecieve($this->req[\Our\NameConst::data]['orderId']);
        $this->success(new \stdClass(),\Our\DescribeConst::confirmOrderSuccess);
    }
    /**
     * 获得物流信息
     *
     * @ccw
     */

    public function getExpressAction(){
        $orderService=\Business\Order\OrderServiceModel::getInstance();
        $orderService->getExpressInfo($this->req[\Our\NameConst::data]['orderId']);
        $expreddInfo=\Our\RedisHelper::cachedFunction(\Redis\Db5\OrderRedisModel::getInstance(),array(&$orderService, 'getExpressInfo'),array($this->req[\Our\NameConst::data]['orderId']),\Our\ApiConst::oneHour);;
        $this->success($expreddInfo,\Our\DescribeConst::getExpreeSuccess);
    }



    /**
     * 获得退款详情
     *
     * @ccw
     */
    public function refundOrderAction(){
        $refundService =\Business\Order\RefundServiceModel::getInstance();
        $refund=$refundService->getRefundOrder($this->memberId,$this->req[\Our\NameConst::data]['orderId'],$this->req[\Our\NameConst::data]['goodsId']);
        $this->success($refund);
    }

    /**
     * 申请退货退款接口
     *
     * @ccw
     */
    public function addRefundAction(){
        $refundService =\Business\Order\RefundServiceModel::getInstance();
        $res=$refundService->addRefund($this->memberId,$this->req[\Our\NameConst::data]);
        $this->success(array('refundId'=>$res),\Our\DescribeConst::applySuccess);

    }


    /**delete
     * 获得退款列表
     *
     * @ccw
     */
    public function getRefundsAction(){
        $refundService=\Business\Order\RefundServiceModel::getInstance();
        $pageIndex=$this->getPageIndex();
        $pageSize=$this->getPageSize();
        $res=$refundService->getList($this->memberId,$pageIndex,$pageSize);
        $this->success($res);
    }
    /**d
     * 删除订单接口
     *
     * @ccw
     */
    public function deleteAction(){
        $orderService=\Business\Order\OrderServiceModel::getInstance();
        $orderService->delete($this->memberId,$this->req[\Our\NameConst::data]['orderId']);
        $this->success(new \stdClass(),\Our\DescribeConst::deleteOrderSuccess);
    }
    /**d
     *获得配送详情
     *
     *
     * @ccw
     */
    public function detailAction(){
        $orderService=\Business\Order\OrderServiceModel::getInstance();
        $dettail=$orderService->getDeliveryDetail($this->req[\Our\NameConst::data]['id']);
        $this->success($dettail);
    }

    /**d
     *确认送达
     *
     *
     * @ccw
     */
    public function confirmOrderAction(){
        $orderService=\Business\Order\OrderServiceModel::getInstance();
        $dettail=$orderService->finishDeliveryOrder($this->req[\Our\NameConst::data]['id'],$this->memberId);
        if($dettail){

            $this->success($dettail);
        }else{
            \Error\ErrorModel::throwException(\Error\ErrorModel::throwException(\Error\CodeConfigModel::commonError));
        }

    }



}
