<?php

class CollectionController extends \Our\Controller_AbstractApi {

    public function init(){
        parent::init();
    }
    public function getStoresAction(){
        $pageIndex = $this->getPageIndex();
        $pageSize = $this->getPageSize(\Our\PageConst::pBlPage);
        $this->req[\Our\NameConst::data]['pageIndex'] = $pageIndex;
        $this->req[\Our\NameConst::data]['pageSize'] = $pageSize;
        $info = \Business\User\MemberCenterServiceModel::getInstance()->getStores($this->req[\Our\NameConst::data],$this->memberId);
        $this->success($info);
    }
    public function getGoodsAction(){
        $pageIndex = $this->getPageIndex();
        $pageSize = $this->getPageSize(\Our\PageConst::pBlPage);
        $this->req[\Our\NameConst::data]['pageIndex'] = $pageIndex;
        $this->req[\Our\NameConst::data]['pageSize'] = $pageSize;
        $info = \Business\User\MemberCenterServiceModel::getInstance()->getGoods($this->req[\Our\NameConst::data],$this->memberId);
        $this->success($info);
    }
    /**
     * 关注 店铺
     */
    public function collectStoreAction(){

        \Business\Store\StoreServiceModel::getInstance()->collect($this->req[\Our\NameConst::data],$this->memberId);
        $this->success('',\Our\DescribeConst::collectSuccess);

    }

    /**
     * 扫码关注店铺
     */
    public function updateScanStoreAction(){
        \Business\Store\StoreServiceModel::getInstance()->updateFavoritesStore($this->req[\Our\NameConst::data],$this->memberId);
        $this->success(new \stdClass(),\Our\DescribeConst::scanSuccess);
    }



    /**
     * 关注 商品
     *
     */
    public function collectGoodsAction(){

        \Business\Goods\GoodsCommonServiceModel::getInstance()->collect($this->req[\Our\NameConst::data],$this->memberId);
        $this->success('',\Our\DescribeConst::collectSuccess);
    }

    /**
     * 取关商品
     */
    public function delGoodsAction(){

        \Business\User\MemberCenterServiceModel::getInstance()->delgoods($this->req[\Our\NameConst::data],$this->memberId);
        $this->success('',\Our\DescribeConst::cancelCollectSuccess);

    }

    /**
     * 取关店铺
     */
    public function delStoresAction(){

        \Business\User\MemberCenterServiceModel::getInstance()->delStores($this->req[\Our\NameConst::data],$this->memberId);
        $this->success('',\Our\DescribeConst::cancelCollectSuccess);
    }
}