<?php

namespace Redis\Db6;

/**
 * 分类店铺信息缓存
 */
class ClassStoreRedisModel extends \Redis\Db6\AbstractModel {

    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_class_store';

    /**
     * 计算key
     *
     * @param int $id
     * @return string
     */
    public function calcKey($id) {
        return $this->_tableName . self::DELIMITER . $id;
    }

    /**
     * 根据id查找店铺信息
     *
     * @param int $id
     * @return array
     */
    public function find($id,$expire=\Our\ApiConst::zero) {
        $result = $this->get($this->calcKey($id));
        if($expire>\Our\ApiConst::zero){
            $this->expire($this->calcKey($id),$expire);
        }
        if($this->is_serialized($result)){
            return unserialize($result);
        }
        return $result;
    }

    /**
     * 更新数据
     *
     * @param int $id
     * @param array $data
     */
    public function update($id, $data,$expire=0) {
        return $this->set($this->calcKey($id), serialize($data),$expire);
    }

    public function tableHSet($h,$key,$val,$experio=0){
        return $this->hset($this->calcKey($h),$key,$val,$experio);
    }

    public function tableHGet($h,$key){
        return $this->hget($this->calcKey($h),$key);
    }

    public function tableHMSet($h,$keysvalue,$experio=0){
        return $this->hmset($this->calcKey($h),$keysvalue,$experio);
    }

    public function tableHMGet($h,$keyvalues){
        return $this->hmget($this->calcKey($h),$keyvalues);
    }
    public function tableHGAll($h){
        return $this->hGetAll($this->calcKey($h));
    }

    public function tableDel($h){
        return $this->del($this->calcKey($h));
    }
    public function tableCacheGet($id){
        $result = $this->get($this->calcKey($id));
        return $result;
    }
    public function tableCacheSet($id,$data,$experio){
        $res=$this->set($this->calcKey($id), $data,$experio);
        return $res;
    }

    /**
     * 类实例
     *
     * @var \Redis\Db0\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \Redis\Db0\UserModel
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

}
