<?php
namespace Elasticsearch;
use  Elasticsearch\ClientBuilder;
use Error\CodeConfigModel;
use Error\ErrorModel;
use Our\NameConst;

/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/8/17
 * Time: 15:11
 */
class ElasticsTool{
    protected $dbName;
    protected $tbName;
    protected $client;
    protected function __construct($dbName,$tbName)
    {
        $elasticConfig=\Our\Common::getConfig(NameConst::elasticName);
        $configArray=array(
            'host' => $elasticConfig->host,
            'port' => $elasticConfig->port,
            'scheme' => $elasticConfig->scheme
        );
        try{
            $this->dbName=$dbName;
            $this->tbName=$tbName;
            $this->client =ClientBuilder::create()->setHosts($configArray)->build();
        }catch(\Exception $e){
            ErrorModel::throwException(CodeConfigModel::elasticsError);
        }
    }
    protected function initParams(){
        return [
            'index'=>$this->dbName,
            'type'=>$this->tbName
        ];
    }
    /*
     * 陈传文
     * 创建索引在设置mapping之前要创建索引
     *
     *
     *
     * */
    public function createIndex(){
        try{
            $indexParams=[
                'index'=>$this->dbName,
            ];
            $r=$this->client->indices()->create($indexParams);
            return $r;
        }catch(\Exception $e){
            ErrorModel::throwException(CodeConfigModel::elasticsError);
        }
    }

//    public function create_index()
//    {
//        $indexParams['index'] = 'my_index';
//        $indexParams['type'] = 'my_index';
//        $indexParams['body']['settings']['number_of_shards'] = 2;
//        $indexParams['body']['settings']['number_of_replicas'] = 0;
//        $this->client->create($indexParams);
//    }
    public function add_document()
    {
        $params = array();
        $params['body'] = array(
            'testField' => 'dfdsfdsf'
        );
        $params['index'] = 'my_index';
        $params['type'] = 'my_index';
        $params['id'] = 'w1231313';
        $ret = $this->client->index($params);
    }
    public function delete_index()
    {
        $deleteParams['index'] = 'my_index';
        $this->client->indices()->delete($deleteParams);
    }
    public function deleteDocumentById($docId)
    {
        $deleteParams = array();
        $deleteParams['index'] = $this->dbName;
        $deleteParams['type'] = $this->tbName;
        $deleteParams['id'] =$docId;
        $retDelete = $this->client->delete($deleteParams);
        return $retDelete;
    }
    public function update_document()
    {
        $updateParams = array();
        $updateParams['index'] = 'my_index';
        $updateParams['type'] = 'my_index';
        $updateParams['id'] = 'my_id';
        $updateParams['body']['doc']['asas']  = '111111';
        $response = $this->client->update($updateParams);

    }
    public function search()
    {
        $searchParams['index'] = 'my_index';
        $searchParams['type'] = 'my_index';
        $searchParams['from'] = 0;
        $searchParams['size'] = 100;
        $searchParams['sort'] = array(
            '_score' => array(
                'order' => 'desc'
            )
        );
        // $searchParams['body']['query']['match']['testField'] = 'abc';
        $retDoc = $this->client->search($searchParams);
        print_r($retDoc);
    }
    public function get_document()
    {
        $getParams = array();
        $getParams['index'] = 'my_index';
        $getParams['type'] = 'my_index';
        $getParams['id'] = 'AU4Kn-knWOmOrmyOj2qg';
        $retDoc = $this->client->get($getParams);
        print_r($retDoc);
    }

    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;


    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance($type,$index=NameConst::searchDbName)
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($index,$type);
        }

        return self::$_instance;
    }

}