<?php
namespace DAO;
/**
 * User: liuyuzhen
 * Date: 2018/5/24
 * Time: 10:41
 * Description:
 */
class MemberMappingModel extends \DAO\AbstractModel{
    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_member_mapping';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'id';

    public function init(){
    }


    public function insert($data){
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        $data['gmt_create'] = TIMESTAMP;
        $result = $this->db->insert($this->_tableName)->rows($data)->execute();
        if($result&&$data['member_id']){
            \Our\RedisHelper::delCachedFunction(\Redis\Db0\MemberMappingRedisModel::getInstance(),array(&$this, 'getList'),array(),array($data['member_id']));
        }
        return $result;
    }

    /**
     * 类实例
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     */
    public static function getInstance($dbName = \Our\DbNameConst::salveDBConnectName) {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }

    public function find($condition,$field= \Our\NameConst::allField){
        $this->setDb($this->dbName);
        if(is_array($condition)){
            $condition = $this->db->getSqlWhereByArray($condition);
        }
        $result = $this->db->select($field)->from($this->_tableName)->where($condition)->fetchOne();
        return $result;
    }

    public function getList($where,$field = \Our\NameConst::allField,$orders = array()){
        $this->setDb($this->dbName);
        if(is_array($where)){
            $where = $this->db->getSqlWhereByArray($where);
        }
        if($orders){
            foreach($orders as $key=>$order){
                $this->db->order($key,$order);
            }
        }
        return $this->db->from($this->_tableName)->select($field)->where($where)->fetchAll();
    }

    public function getAvailableMemberMappingList($memberId,$field = \Our\NameConst::allField){
        $where['member_id'] = $memberId;
        $mappingList = \Our\RedisHelper::cachedFunction(\Redis\Db0\MemberMappingRedisModel::getInstance(),array(&$this, 'getList'),array($where,$field),\Our\ApiConst::oneDaySecond,array($memberId));
        return $mappingList;
    }


    public function validMemberMapping($where,$memberId=null){
        if(!$where['userType']){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyUserType);
        }
        if(!in_array($where['userType'],array_keys(\Our\ArrayConst::userType))){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::wrongUserType);
        }
        if(!$where['openid']){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyUserOpenid);
        }
        if($memberId){
            $con['member_id'] = $memberId;
            $con['user_type'] = $where['userType'];
            $result = $this->find($con,'member_id');
            if($result){
                \Error\ErrorModel::throwException(\Error\CodeConfigModel::memberExistBindingInfo);
            }
        }
        $condition['openid'] = $where['openid'];
        $condition['user_type'] = $where['userType'];
        $result = $this->find($condition,'member_id');
        if($result){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::userAlreadyBind);
        }
        return true;
    }


    public function validCancelMapping($where,$memberId){
        if(!$where['userType']){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emptyUserType);
        }
        $condition['member_id'] = $memberId;
        $condition['user_type'] = ($where['userType']==\Our\ApiConst::userFromWx)?array('in',array(\Our\ApiConst::userFromWx,\Our\ApiConst::wechatUserType)):$where['userType'];
        $result = $this->find($condition,'member_id');
        if(!$result){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::bindingUserNotExist);
        }
        return true;
    }


    public function del($where){
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        $condition = $where ;
        if(is_array($where)){
            $condition = $this->db->getSqlWhereByArray($where);
        }
        $result  = $this->db->delete($this->_tableName)->where($condition)->execute();
        if($result&&isset($where['member_id'])){
            \Our\RedisHelper::delCachedFunction(\Redis\Db0\MemberMappingRedisModel::getInstance(),array(&$this, 'getList'),array(),array($where['member_id']));
        }
        return $result;
    }
}