<?php

namespace Business\User;

use DAO\MbUserTokenModel;
use DAO\MemberModel;
use DAO\SaleMemberModel;
use Error\CodeConfigModel;
use Error\ErrorModel;
use Our\ApiConst;
use Our\Common;
use Our\CommonExtension;


/**
 * 用户登录业务
 */
class MemberServiceModel extends \Business\AbstractModel
{

    private $memberDao;
    private $memberDb0Redis;
    private $sessionDb0Redis;
    public function init()
    {
        $this->memberDao = MemberModel::getInstance();
        $this->memberDb0Redis=\Redis\Db0\MemberRedisModel::getInstance();
        $this->sessionDb0Redis= \Redis\Db0\SessionRedisModel::getInstance();
    }

    /**
     * 登录业务
     *
     * @param array $params
     * @return
     */
    public function login()
    {
        $userM = MemberModel::getInstance();
        //系统封装好的方法
        $one = $userM->find(1);
        //系统自带走从库方法
        return $one;
        $user = $userM->query();
        //系统原生走主库
        $user = $userM->update("UPDATE Member SET member_name='abc' WHERE member_id=1");
        return $user;
    }
    public function saveMember($member){
        $this->addOrUpdateMbUserToken($member);
        foreach($member as $key =>$value){
            if(!$value){
                $member[$key]=ApiConst::zero;
            }
        }
        $member['sendTime']=TIMESTAMP;
        $this->memberDb0Redis->tableHMSet(trim($member['member_id']),$member,ApiConst::tenDaySecond);
    }


    public function clearKey($key){
        $this->sessionDb0Redis->delSessionKey($key);

        //  $this->memberDb0Redis->tableDel($key);
    }
    public function checkUserNamePassWord($mobile, $password)
    {
        if (empty($mobile)) {
            ErrorModel::throwException(CodeConfigModel::emptyMobileForLogin);
        }
        if (empty($password)) {
            ErrorModel::throwException(CodeConfigModel::emptyPassword);
        }
        if (!Common::checkMobilePhone($mobile)) {
            ErrorModel::throwException(CodeConfigModel::wrongTelnumber);
        }
        return true;

    }

    public function getOneByMobileAndPassword($mobile, $password)
    {
        $password = md5($password);
        $member= $this->memberDao->getOneByMobileAndPassword($mobile, $password);
        return $member ? $member : false;
    }

    /**
     * 登录业务
     *
     * @var \Business\User\LoginV2Model
     */
    private static $_instance = null;

    /**
     * 单例模式获取类实例
     *
     * @return \Business\User\LoginV2Model
     */
    public static function getInstance()
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

    public function addOrUpdateMbUserToken($data)
    {
        $mbUserToken = MbUserTokenModel::getInstance();
        $inserData = [
            'member_id' => $data['member_id'],
            'member_name' => $data['member_name'],
            'token' => $data['key'],
            'login_time' => time(),
            'client_type' => Common::getDriverType(true),
        ];
        return $mbUserToken->insertOrUpdate($inserData);
    }

    public function findMbUserTokenByMemberId($memberId)
    {
        if ($memberId != (int)$memberId) {
            return false;
        }
        $mbUserTokenModel = MbUserTokenModel::getInstance();
        return $mbUserTokenModel->findByMemberId($memberId);
    }

    public function getMemberInfo($memberId)
    {
        $memberDao=\DAO\MemberModel::getInstance(\Our\DbNameConst::masterDBConnectName);
        $member=$memberDao->getInfo($memberId);
        $returnMember=array(
            'memberId'=>$member['memberId'],
            'memberName'=>$member['memberName'],
            'memberTrueName'=>$member['memberTrueName'],
            'memberAvatar'=>$member['memberAvatarUrl'],
            'memberSex'=>$member['memberSex'],
            'memberBirthday'=>$member['memberBirthday'],
            'memberMobile'=>$member['memberMobile'],
            'memberMobileBind'=>$member['memberMobileBind'],
            'sellerId'=>$member['sellerId'],
            'diliverymanId'=>$member['diliverymanId'],
        );
        $memberMappingDao = \DAO\MemberMappingModel::getInstance(\Our\DbNameConst::masterDBConnectName);
        $memberMappingList = $memberMappingDao->getAvailableMemberMappingList($memberId);
        foreach($memberMappingList as $memberMapping){
            if($memberMapping['user_type']== \Our\ApiConst::userFromWeibo){
                $returnMember['isWeiboBind'] = \Our\ApiConst::one;
            }else if($memberMapping['user_type'] == \Our\ApiConst::userFromQQ){
                $returnMember['isQqBind'] = \Our\ApiConst::one;
            }else if($memberMapping['user_type'] == \Our\ApiConst::wechatUserType){
                //$returnMember['isWechatBind'] = \Our\ApiConst::one;

                $returnMember['isWxBind'] = \Our\ApiConst::one;
            }else if($memberMapping['user_type'] == \Our\ApiConst::userFromWx){
                $returnMember['isWxBind'] = \Our\ApiConst::one;
            }
        }
        if(!isset($returnMember['isWeiboBind'])){
            $returnMember['isWeiboBind'] = \Our\ApiConst::zero;
        }
        if(!isset($returnMember['isQqBind'])){
            $returnMember['isQqBind'] = \Our\ApiConst::zero;
        }
        /*if(!isset($returnMember['isWechatBind'])){
            $returnMember['isWechatBind'] = \Our\ApiConst::zero;
        }*/
        if(!isset($returnMember['isWxBind'])){
            $returnMember['isWxBind'] = \Our\ApiConst::zero;
        }
        return $returnMember;
    }

    public function saveMemberInfo($where,$memberId){
        $memberDao=\DAO\MemberModel::getInstance(\Our\DbNameConst::masterDBConnectName);
        $data = $memberDao->getValidMember($where);

        $result = $memberDao->saveInfo($data,$memberId);
        return $result;
    }


    /**
     * 保存会员头像
     * @param $where 参数
     * @param $memberId 对应会员
     * @return mixed 返回头像地址
     * @throws \Exception
     * @throws \OSS\Core\OssException
     */
    public function saveMemberAvatar($where,$memberId){
        $memberAvatar = $where['memberAvatar'];
        $memberImage = $where['memberImage'];
        if(!($memberAvatar||$memberImage)){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::emtpyMemberAvatar);
        }
        if($memberAvatar){
            $memberAvatarName = \Our\ImageConst::memberAvatarPrefix.$memberId;
            $result = \Our\ImageUtil::uploadBase64Image($memberAvatar,\Our\ImageConst::memberAvatar,$memberAvatarName);
            if($result){
                $data['member_avatar'] = $memberAvatarName;
                $memberDao=\DAO\MemberModel::getInstance(\Our\DbNameConst::masterDBConnectName);
                $result = $memberDao->saveInfo($data,$memberId);
            }
            return $result;
        }
        if($memberImage){
            $data['member_avatar'] = $memberImage;
            $memberDao=\DAO\MemberModel::getInstance(\Our\DbNameConst::masterDBConnectName);
            $result = $memberDao->saveInfo($data,$memberId);
            return $result;
        }
    }


    /**
     * 退出登录
     */
    public function logOut($key){
        $sess=\Yaf\Session::getInstance();
        $sess->del('member_id');
        $this->clearKey($key);
        return true;
    }
    /**
     * 退出登录
     */
    public function logOutTest($key){

        $this->sessionDb0Redis->delSessionKeyTest($key);
        return true;
    }

    /**
     * 注册时验证手机号码
     * @param $where
     * @return bool
     * @throws \Exception
     */
    private function validRegisterSmsCode($where){
        //验证手机号码
        if($where['code']=='666666'&&(APP_ENV=='test'||APP_ENV=='develop')){
            return true;
        }
        $validData['key'] = $where['key'];
        $validData['messageType'] = ApiConst::messageTypeRegister;
        $validData['mobile'] = $where['mobile'];
        $validData['code'] = $where['code'];
        $shortMessageDao  = \DAO\ShortMessageModel::getInstance();
        if(!$shortMessageDao->validCode($validData)){
            \Error\ErrorModel::throwException(\Error\CodeConfigModel::wrongSmsCode);
        }
        return true;
    }

    /**
     * 注册保存用户信息
     * @param $where
     * @return mixed 保存成功,返回memberId
     * @throws \Exception
     */
    private function saveRegisterMemberInfo($where){
        $memberDao = \DAO\MemberModel::getInstance(\Our\DbNameConst::masterDBConnectName);

        //构造需要保存的会员信息
        $member['member_name'] = \Our\CommonExtension::createNewMemberName();
        $member['member_mobile'] = $where['mobile'];
        $member['member_mobile_bind'] = \Our\ApiConst::one;
        $member['member_passwd'] = md5($where['password']);
        $member['member_time'] = TIMESTAMP;
        $result = $memberDao->addInfo($member);
        return $result;
    }

    private function saveWxInfoMemberInfo($where){
        $memberDao = \DAO\MemberModel::getInstance(\Our\DbNameConst::masterDBConnectName);

        //构造需要保存的会员信息
        $member['member_name'] = \Our\CommonExtension::createNewMemberName();
        $result = $memberDao->addInfo($member);
        return $result;
    }

    /**
     * 保存店铺会员
     * @param $memberId
     * @return bool
     */
    private function saveStoreMembers($memberId){
        $sess=\Yaf\Session::getInstance();
        $scan_store_ids = $sess->get('scan_store_ids');//扫码带入的店铺ID
        if($scan_store_ids){
            $storeMembers = array();
            foreach($scan_store_ids as $storeId){
                $storeMember = array();
                $storeMember['store_id'] = $storeId;
                $storeMember['member_id'] = $memberId;
                $storeMember['fav_from'] = \Our\ApiConst::scanFavor;
                $storeMembers[] = $storeMember;
            }
            /*$storeMemberDao = \DAO\StoreMemberModel::getInstance(\Our\DbNameConst::masterDBConnectName);
            $result = $storeMemberDao->addBatch($storeMember);*/
            $favoritesStoreDao = \DAO\FavoritesStoreModel::getInstance();
            $result = $favoritesStoreDao->insertAll($storeMembers);
            if(!$result){
                \Our\Log::getInstance()->write(json_encode($storeMembers).'扫码数据写入失败');
                return false;
            }
        }
        $scan_sale_ids = $sess->get('scan_sale_ids');
        if($scan_sale_ids){
            $saleIds = array_keys($scan_sale_ids);
            $saleList = \DAO\SaleModel::getInstance()->getList(array('sale_id'=>array('in',$saleIds)),'sale_id,sale_act_id,member_id');
            $saleMembers = array();
            foreach($saleList as $sale){
                $saleMember = array();
                $saleMember['member_id'] = $memberId;
                $saleMember['store_id'] = $scan_sale_ids[$sale['sale_id']];
                $saleMember['sale_id'] = $sale['member_id'];
                $saleMember['sale_act_id'] = $sale['sale_act_id'];
                $saleMembers[]=$saleMember;
            }
            $resultS                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  