<?php

namespace DAO\Order;


use Error\CodeConfigModel;
use Error\ErrorModel;
use OSS\Common;
use Our\ApiConst;
use Our\DbNameConst;
use Our\DescribeConst;
use Our\ImageConst;
use Our\ImageUtil;
use Our\OrderConst;

class RefundReturnModel extends \DAO\AbstractModel {

    public $errorCode;
    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_refund_return';
    private $refundReturnField="seller_state,refund_state,is_platform_in,platform_state";
    private $sumField="buyer_id as buyerId,store_id as storeId,goods_num as goodsNum,refund_amount as refundAmount,is_suc_refund as isSucRefund,gmt_update as gmtUpdate";
    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'refund_id';
    public function init(){

    }
    public function getCount($where){
        $this->setDb();
        return $this->db->from($this->_tableName)->where($where)->fetchNum();
    }

    public function getAll($where,$field,$db=DbNameConst::salveDBConnectName){
        $this->setDb($db);
        $list = $this->db->select($field)->from($this->_tableName)->where($where)->fetchAll();
        return $list;
    }

    /**
     * 更新数据
     * @param $data
     * @param $where
     * @return mixed
     */
    public function update($where, $data)
    {
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        return $this->db->update($this->_tableName)->where($where)->rows($data)->execute();
    }
   //更新退货物流信息
    public function updateReturnShippingByRefundId($refundId,$data){
        $where[$this->_primaryKey]=$refundId;
        $updateData['express_id']=$data['expressId'];
        $updateData['invoice_no']=$data['invoiceNo'];
        $updateData['address_id']=$data['addressId'];
        $updateData['goods_state']=ApiConst::goodsStateWaitRecieve;
        $updateData['ship_time']=TIMESTAMP;
        return $this->update($where,$updateData);
    }
    //检查是否可以添加退货物流信息
    public function checkIsAddReturnShipping($refundReturn){
        $isReturn=TRUE;
        if($refundReturn['sellerState']!=ApiConst::refundSellerAgree){
            $this->errorCode=CodeConfigModel::notReturnAgree;
            $isReturn=FALSE;
        }
        if($refundReturn['refundType']!=ApiConst::refundTypeGoods){
            $this->errorCode=CodeConfigModel::isNotReturn;
            $isReturn=FALSE;
        }
        if($refundReturn['refundShippingType']!=ApiConst::express){
            $this->errorCode=CodeConfigModel::isNotExpressType;
            $isReturn=FALSE;
        }
        if($refundReturn['addressId']>ApiConst::zero){
            $this->errorCode=CodeConfigModel::isNotExpressType;
            $isReturn=FALSE;
        }
        return $isReturn;
    }
    /**
     * 申请平台介入
     * @param $data
     * @param $where
     * @return mixed
     */
    public function updateStatusByBuyerIdAndRefundId($buyerId,$refundId,$applyMessage)
    {
        $where['refund_id'] = $refundId;
        $where['buyer_id'] = $buyerId;
        $data['is_platform_in']=ApiConst::platIn;
        $data['platform_in_reason']=$applyMessage;
        return $this->update($where, $data);
    }
    /**
     * 获取单条数据
     * @param $where
     * @return array
     */
    public function find($where,$field='*')
    {
        $this->setDb($this->dbName);
        $data = $this->db->from($this->_tableName)->select($field)->where($where)->fetchOne();
        return $data;
    }

    public function findByRefundId($refundId,$field='*')
    {
        $where['refund_id'] = $refundId;
        return $this->find($where,$field);
    }

    public function findByMemberIdAndRefundId($memberId,$refundId,$field='*'){
        $where['buyer_id']=$memberId;
        $where['refund_id']=$refundId;
        return $this->find($where,$field);
    }

    public function getAllByOrderIds($orderIds,$field='*'){
        if(is_array($orderIds)){
            $where=Common::format(" order_id in {0}",implode(',',$orderIds));
        }else{
            $where['order_id']=$orderIds;
        }
        return $this->getAll($where,$field);
    }

    public function getStatusExtent($returnRefund){
        if($returnRefund['sellerState']==ApiConst::refundSellerAgree){
            if($returnRefund['isSucRefund']==ApiConst::refundSuccess){
                return OrderConst::refoundSuccess;
            }
            if($returnRefund['refundType']==ApiConst::refundTypeMoney){
                 return OrderConst::sellerAgree;
            }
            if($returnRefund['refundType']==ApiConst::refundTypeGoods){
                if($returnRefund['isSucRefund']==ApiConst::refundSuccess){
                    return OrderConst::sellerAgreeGoods;
                }else{
                    return OrderConst::waitSellerRecieve;
                }
            }
        }
        if($returnRefund['sellerState']==ApiConst::refundSellerRefuse){
            if($returnRefund['isSucRefund']==ApiConst::refundSuccess){
                return OrderConst::refoundSuccess;
            }
            if($returnRefund['isPlatformIn']==ApiConst::platIn){
                return OrderConst::platFromProccess;
            }
            if($returnRefund['refundType']==ApiConst::refundTypeMoney){
                return OrderConst::sellerRefuse;
            }
            if($returnRefund['refundType']==ApiConst::refundTypeGoods){
                return OrderConst::sellerRefuseGoods;
            }
        }
    }
    public function getRefundTextStatus($refundReturn){
        $refundText='';
        switch($refundReturn['sellerState']){
            case ApiConst::refundSellerVerify:$refundText=OrderConst::waitVerify;break;
            case ApiConst::refundSellerAgree:$refundText=$this->getStatusExtent($refundReturn);break;
            case ApiConst::refundSellerRefuse:$refundText=$this->getStatusExtent($refundReturn);break;
        }
        return $refundText;
    }
    public function getStatusText($orderId){
        $where['order_id']=$orderId;
        $refundReturn= $this->db->from($this->_tableName)->select($this->refundReturnField)->where($where)->fetchOne();
        return $this->getRefundTextStatus($refundReturn);
    }
    /**
     * 根据退货退款订单详情获取是否可申请平台介入
     *
     * @param
     * @return array
     */
    public function isPlatformIn($refundInfo){
           if(($refundInfo['isPlatformIn']==ApiConst::platNotIn&&$refundInfo['sellerState']==ApiConst::refundSellerRefuse) || $refundInfo['buyerRefundAmount']>$refundInfo['refundAmount']){
                return TRUE;
           }else{
               return FALSE;
           }
    }
    /**
     * 根据订单状态判断是否可以退款退货
     *
     * @param
     * @return array
     */
    public function isReturn($order) {
        $refund = FALSE;//默认不允许退款退货
        $orderState = $order['orderState'];//订单状态
        ApiConst::orderStateWaitRecieve;//30:已发货
        ApiConst::orderStateComplete;//40:已收货
        switch ($orderState) {
            //已发货
            case ApiConst::orderStateWaitRecieve:
                $payment_code = $order['paymentCode'];//支付方式
                if ($payment_code != 'offline') {//货到付款订单在没确认收货前不能退款退货
                    $refund = TRUE;
                }else{
                    ErrorModel::throwException(CodeConfigModel::returnErrorAfterPay);
                }
                break;
            //已收货
            case  ApiConst::orderStateComplete:
                $order_refund = ApiConst::canRefundDay;//15:收货完成后可以申请退款退货
                $delay_time = $order['delayTime']+60*60*24*$order_refund;
                if ($delay_time > time()) {
                    $refund = TRUE;
                }else{
                    ErrorModel::throwException(CodeConfigModel::returnBeyondTimeError);
                }
                break;
            default:
                $refund = FALSE;
                break;
        }

        return $refund;
    }
    /**
     * 退款退货申请编号
     *
     * @param
     * @return array
     */
    public function getRefundsn($store_id) {
        $result = mt_rand(100,999).substr(100+$store_id,-3).date('ymdHis');
        return $result;
    }
    /**
     * 退款退货申请编号
     *
     * @param
     * @return array
     */
    public function getRefundPics($pics){
        $picsRes=array();
        if($pics){
            foreach($pics as $pic){
                $readFile=\Our\Common::getStaticFile($pic,ImageConst::refund);
                array_push($picsRes,$readFile);
            }
        }
        return $picsRes;

    }
    /**
     * 增加退款退货
     *
     * @param
     * @return int
     */
    public function addRefundReturn($refund_array, $order = array(), $goods = array()) {
        $this->setDb($this->dbName);
        if (!empty($order) && is_array($order)) {
            $refund_array['order_id'] = $order['orderId'];
            $refund_array['order_sn'] = $order['orderSn'];
            $refund_array['store_id'] = $order['storeId'];
            $refund_array['store_name'] = $order['storeName'];
            $refund_array['buyer_id'] = $order['buyerId'];
            $refund_array['buyer_name'] = $order['buyerName'];
        }
        if (!empty($goods) && is_array($goods)) {
            $refund_array['goods_id'] = $goods['goodsId'];
            $refund_array['order_goods_id'] = $goods['recId'];
            $refund_array['order_goods_type'] = $goods['goodsType'];
            $refund_array['goods_name'] = $goods['goodsName'];
            $refund_array['commis_rate'] = $goods['commisRate'];
            $refund_array['goods_image'] = $goods['goodsImage'];
        }
        if(!isset($refund_array['refund_sn'])|| !$refund_array['refund_sn']){
            $refund_array['refund_sn'] = $this->getRefundsn($order['storeId']);
        }
        $refund_id = $this->db->insert($this->_tableName)->rows($refund_array)->execute();
        // 发送商家提醒
        $param = array();

        if (intval($refund_array['refund_type']) == ApiConst::refundTypeMoney) {    // 退款
            $param['code'] = 'refund';
        } else {    // 退货
            $param['code'] = 'return';
        }
        $param['store_id'] = $order['storeId'];
        $type = $refund_array['order_lock'] == ApiConst::refundTypeGoods ? DescribeConst::beforeSale : DescribeConst::afterSale;
        $param['param'] = array(
            'type' => $type,
            'refund_sn' => $refund_array['refund_sn']
        );
       // QueueClient::push('sendStoreMsg', $param);

        return $refund_id;
    }
    //删除订单详情缓存
    public function deleteFindByOrderIdCache($refundId)
    {
        return \Our\RedisHelper::delCachedFunction(\Redis\Db5\OrderRedisModel::getInstance(), array(&$this, 'findByRefundId'), array($refundId));
    }

    //删除订单列表缓存
    public function deleteGetListByMemberId($memberId)
    {
        return \Our\RedisHelper::delCachedFunction(\Redis\Db5\OrderRedisModel::getInstance(), array(&$this, 'getList'), array(), array($memberId));
    }

    //删除订单缓存
    public function deleteRefundCache($memberId, $refundId=false)
    {
        if(!empty($memberId)){
            $this->deleteGetListByMemberId($memberId);
        }
        if(!empty($refundId)){
            $this->deleteFindByOrderIdCache($refundId);
        }
    }
    /**
     *获得退货退款列表
     *
     * @var \DAO\getList
     */
    public function getList($where, $field, $pageIndex, $pageSize, $order = array('add_time' => 'desc'))
    {
        $this->setDb($this->dbName);
        $refunds = $this->lists($where, $order, $field, $pageIndex, $pageSize);
        return $refunds ? $refunds : array();
    }
    //根据传过来的退款类型获取退款类型
    public function getRefundTypeByType($refundType){
        $returnType=ApiConst::refundTypeGoods;
        if ($refundType!= ApiConst::refundTypeGoods) {
            $returnType = ApiConst::refundTypeMoney;
        }
        return $returnType;
    }

    public function getMemberStoreStaticsByGmtUpdate($gmtUpdate,$pageIndex,$pageSize){
        $this->setDb($this->dbName);
       $where =\Our\Common::format(' gmt_update>={0} and gmt_update<{1} and is_suc_refund={2}',$gmtUpdate,TIMESTAMP,ApiConst::refundSuccess);
        $res=$this->lists($where,array('gmt_update'=>'asc'),$this->sumField,$pageIndex,$pageSize);
        return $res['list']?$res:false;
    }
    /**
     *获得退货退款列表
     *
     * @var \DAO\getList
     */
    public function updateRefundShipping(){

    }

    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;


    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance($dbName=DbNameConst::salveDBConnectName)
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }

}
