<?php

namespace Error;

/**
 * 错误码设置类
 */
class CodeConfigModel {
    //通用错误
    const commonError=-1;
    const paramsError=-2;
    //用户登录错误
    const emptyUsername=10001;
    const emptyPassword=10002;
    const errorUsernameOrPassword=10003;
    const noLogin = 10005;

    const memberNameLengthLimit = 10004;
    const illegalMemberBirthday = 10006;
    const saveMemberFailed = 10007;
    const emtpyMemberAvatar = 10008;
    const saveMemberAvatarFailed = 10009;
    const saveStoreMemberFailed = 10010;
    const saveMemberDeviceInfoFailed = 10011;
    const emptyMemberName = 10012;
    const emptyRegisterMobile = 10013;
    const emptyVerifyCode = 10014;
    const invalidVerifyCode = 10015;
    const emptyDeviceType = 10016;
    const emptyDeviceUniqueCode = 10017;
    const addMemberInfoFailed = 10018;
    const registerMemberFailed = 10019;
    const wrongMobileFormat = 10020;
    const registerMobileExist = 10021;
    const emptyUserType = 10022;
    const wrongUserType = 10023;
    const emptyUserAvatar = 10024;
    const emptyUserNickname = 10025;
    const addMemberMappingError = 10026;
    const userAlreadyBind = 10027;
    const emptyPlatformType = 10028;
    const wrongPlatformInfo = 10029;
    const loginBindUserInfoFailed = 10030;
    const bindingUserNotExist = 10031;
    const cancelBindingUserFailed = 10032;
    const emptyUserOpenid = 10033;
    const bindingSuccess = 10034;
    const memberMobileExist = 10035;
    const checkMobileFailed = 10036;
    const findPasswordSmsValidFailed = 10037;
    const emptyPasswordAndRepassword = 10038;
    const differentPasswordAndRepassword = 10039;
    const passwordLimit = 10040;
    const findPasswordLimit = 10041;
    const setPasswordFailed = 10042;
    const emptyOldPassword = 10043;
    const worngOldPassword = 10044;
    const changePasswordFailed = 10045;
    const emptyMobile = 10046;
    const sameWithOldMobile = 10047;
    const changeMobileFailed = 10048;
    const wrongTelnumber=10049;
    const memberBirthdayError = 10050;
    const wxUserInfoAuthError = 10051;
    const emptyWxUserInfoAuth = 10052;
    const emptyWxOpenid = 10053;
    const emptyWxInfo = 10054;
    const wrongWxOpenid = 10055;
    const wxAuthInfoLoginFailed = 10056;
    const emptyOrWrongAuthUserType = 10057;
    const emptyMobileForLogin = 10058;
    const memberExistBindingInfo = 10059;
    const wrongMemberSex = 10060;
    const noAvailForDelMember = 10061;
    const emptyMobileForDelMember  = 10062;
    const emptyMemberForDelMember = 10063;
    const deleteMemberFailed = 10064;
    const wxMemberHasBindMobile = 10065;
    const wxMemberBindMobileSendCode = 10066;
    const wxMemberBindMobileFailed = 10067;
    const mobileExistMember = 10068;
    const emptyEncryptedDataAndVi = 10069;
    const getUnionidFailed = 10070;
    const saveMemberMapppingFailed = 10071;
    const emptyWxSetting=10072;
    const getWxAccessTokenFail=10073;
    const wrongMappingDataForBindMembmer = 10074;
    const otherMemberOpenIdBindForMember = 10075;
    const updateMobileMembmerFailed = 10076;
    const updateMobileMembmerMappingFailed = 10077;
    const currentMobileHasBeenBind = 10078;
    const otherDriverLogin=10105;
    const emptyLog = 10106;
    const writeLogFailed = 10107;
    const wrongTimeForReadLog = 10108;
    const saveUserMappingFailed = 10109;
    const registerMemberInfoFailed = 10110;
    const authMemberExistMobile = 10111;

    //访问错误
    const illegalAccess=200001;

    const maxGetAccess=200002;
    const isLogin=200003;
    const signWrong=200004;
    const authError=200005;
    const authExpire=200006;
    //商品
    const emptyCommonId=20001;
    const goodsNotExist=20002;
    const groupNotExist=20003;


    //店铺相关错误代码
    const illegalFavStore = 40001;
    const emptyStore = 40002;
    const emptyReportStoreDesc = 40003;
    const emptyReportStoreType = 40004;
    const emptyStores = 40005;
    const storeNotExistOrClose = 40006;
    const emptyStoreId = 40007;
    const saveReportError = 40008;
    const stroeReceiveError=40009;

    //购物车
    const wrongCartType = 50001;
    const emptyAddCartMemberId = 50002;
    const emptyCartGoodsId = 50003;
    const emptyCartGoodsNum = 50004;
    const emptyCartBlId = 50005;
    const emptyCartBlNum = 50006;
    const noStorageForCart = 50007;
    const offlineGoodsOrNotExist = 50008;
    const emptyCartBundling = 50009;
    const cartClosedBundling = 50010;
    const lessBundlingNumForCart = 50011;
    const bundlingGoodsOffline = 50012;
    const addCartFailed = 50013;
    const lessGoodsNumForCart = 50014;
    const emptyMemberCarts = 50015;
    const overLimitCartCount = 50016;
    const emptyCartById = 50017;
    const unusaulCartForMember = 50018;
    const emptyCartId = 50019;
    const wrongGoodsForEditCart = 50020;
    const wrongMemberIdForEditCart = 50021;
    const editCartFailed = 50022;
    const delCartFailed = 50023;
    const wrongCartGoodsCommonId = 50024;
    const emptyCartIdsForDel = 50025;
    const wrongCartIdsForDel = 50026;
    const moveToFavoritesFailed = 50027;
    const moveToFavoritesDelCartFailed = 50028;
    const emptyCartIdsForCheckout = 50029;
    const storeNoDeliveryTypeForBuy = 50030;
    const storeNoPaywayForBuy = 50031;
    const emptyGoodsIdOrBlIdForBuyNow = 50032;
    const emptyGoodsNumForBuyNow = 50033;
    const wrongBundlingForBuyNow = 50034;
    const wrongGoodsForBuyNow = 50035;
    const offlineGoodsListOrNotExist = 50036;
    const goodsListNoStorage =50037;
    const emptyPBundlingdForOrder = 50038;
    const pBundlingOfflineForOrder = 50039;
    const pBundlingNoStorageForOrder = 50040;


    //订单相关错误码
    const orderNotExist = 30001;
    const orderError = 30002;
    const refundRefuseByStore = 30003;
    const emptyDescCredit=30012;
    const emptyDeliveryCredit=30013;
    const emptyServiceCredit=30014;
    const emptyScores=30016;
    const emptyGoodsId=30017;
    const notAllowCancel=30019;
    const notAllowComplete=30020;
    const refundSuccess=30021;
    const returnErrorAfterPay=30022;
    const returnBeyondTimeError=30023;
    const applyError=30024;
    const notReturnAgree=30025;
    const isNotReturn=30026;
    const isNotExpressType=30027;
    const notExistRefund=30028;
    const sendRefundShippingFail=30029;
    const alreadySendRefundShipping=30030;
    const buyerCancelError=30031;
    const refundCancelError=30032;
    const storeCancelError=30033;
    const systemCancelError=30034;
    const systemReceivePayError=30035;
    const complainError=30036;
    const paymentError=30037;
    const modifyPriceError=30038;
    const spayPriceError=30039;
    const sendError=30040;
    const receiveError=30041;
    const evaluationError=30042;
    const lockError=30043;
    const deliverError=30044;

    const deleteError=30045;
    const restoreError=30046;
    const shareError=30047;
    const orderDeleteError=30048;
    const noAddressForOrder = 30049;
    const emptyCartIdsForOrder = 30050;
    const emptyParamForOrder = 30051;
    const emptyStoreIdForOrder = 30052;
    const wrongPaywayForOrder = 30053;
    const wrongDeliveryTypeForOrder = 30054;
    const wrongTimeParamForStoreDelivery = 30055;
    const wrongStoreIdsForOrder = 30056;
    const wrongCartStoreForOrder = 30057;
    const bundlingGoodsNotExist = 30058;
    const noStorageForBundlingGoods = 30059;
    const bundlingGoodsOfflineForCartOrOrder = 30060;
    const goodsNoStoreForCartOrOrder = 30061;
    const goodsOfflineForCartOrOrder = 30062;
    const wrongCouponIdForOrder = 30063;
    const sameCoupnIdsForOrder = 30064;
    const wrongCouponForStoreOrder = 30065;
    const noStoreDeliveryTypeForOrder = 30066;
    const wrongStoreDeliveryFeeForOrder = 30067;
    const wrongDeliveryTimeRangeForOrder = 30068;
    const noBuyerDeliveryTypeForOrder = 30069;
    const noDeliveryFeeForBuyerType = 30070;
    const noExpressDeliveryForOrder = 30071;
    const wrongPaywayForStoreForOrder = 30072;
    const emptyDeliveryFeeForOrder = 30073;
    const saveOrderPayFailed = 30074;
    const wrongTotalFeeForOrder = 30075;
    const saveOrderFailed = 30076;
    const updateMemberCouponFailed = 30077;
    const updateAddressFailedForOrder = 30078;
    const updateGoodsStorageForOrder = 30079;
    const saveOrderCommonFailed = 30080;
    const saveOrderGoodsFailed = 30081;
    const delCartFaileForAddOrder = 30082;
    const orderLogSaveFailedForOrder = 30083;
    const wrongChannelForPay = 30084;
    const emptyPaySnForPay = 30085;
    const wrongOrderPay = 30086;
    const noOrderListForPay = 30087;
    const emptyOrderAmountForPay = 30088;
    const emptyPaySnForOrder = 30089;
    const wrongPaySnForOrder = 30090;
    const updateOrderPayedStatusFailed = 30091;
    const wrongOrderPayForOrder  = 30092;
    const emptyOrderForPay = 30093;
    const emptyOrderIdForPay = 30094;
    const noRightForOrder = 30095;
    const wrongPayForOrder = 30096;
    const newPaySnInsertFailed = 30097;
    const updateOrderForPayFailed = 30098;
    const noOrderListForPaySn = 30099;
    const wrongBlIdAndGoodsIdForOrder = 30100;
    const emptyGoodsIdOrBlIdForOrder = 30101;
    const emptyGoodsNumForBuyNowOrder = 30102;
    const failedUpdateFavoritesStoreForOrder = 30103;
    const orderUpdatePaySnFailed = 30104;
    const receiveCouponFailedForOrder = 30105;
    const blGoodsStorageToDBFailedForOrder = 30106;
    const goodsStorageToDBFailedForOrder = 30107;
    const blGoodsStorageToCacheFailedForOrder = 30108;
    const goodsStorageToCacheFailedForOrder = 30109;
    const notExistOrderGoods=300110;
    const notExsitDeliver=300111;
    const notExsitOrder=300112;
    const alreadyExsitRefundGoods=300113;
    const notAllowDelete=300114;
    const platFormAreadyIn=300115;
    //店铺相关错误码

    //商品分类
    const emptyLatLng = 60001;
    const emptyCityCode = 60002;
    const emptyGcId = 60003;
    const emptyStoreIdForOnlineTopClass = 60004;
    const emptyStoreIdForOnlineChildrenClass = 60005;
    const emtpyGcIdForOnlineChildrenClass = 60006;
    const wrongGcIdForStoreIdChildrenClass = 60007;
    //图片上传
    const folderUnwritable = 80001;
    const base64ImageError = 80002;
    const imageUploadFailed = 80003;
    const ossServerSetError = 80004;
    const emptyImageUrl = 80005;
    const imageExtensionsWrong = 80006;
    const emptyImageStr = 80007;


    //短信相关错误码
    const smsCountLimitOut = 90007;
    const smsIsSending = 90008;
    const emptySmsMobile = 90009;
    const emptySmsMessageType = 90010;
    const smsSendFail = 90011;
    const emptySmsCode = 90012;
    const emptyRedisSmsCode = 90013;
    const wrongSmsCode = 90014;
    const codeIsSixNumberString = 90015;

    const codeIsSixNumberString1 = 90016;
    //销售员
    const emptySaleGoodsId = 100001;
    const emptySaleGoods = 100002;
    const saleNotLogin = 100003;
    const salePhoneError = 100004;
    const saleNotExist = 100005;
    const saleValidate = 100006;
    const saleNotJoin = 100007;
    const saleActOrGoodsNotExist = 100008;
    //意见信箱
    const emptyFeedbackDescribe = 120001;
    const emptyFeedbackTelepone = 120002;
    const saveFeedbackError = 120003;
    const feedbackTelError = 120004;
    //优惠券
    const emptyCouponId = 130001;
    const emptyCouponStoreId = 130002;
    const emptyMemberCouponState = 130005;
    const wrongMemberCouponState = 130006;
    const emptyMemberCouponMemberId = 130007;
    const couponNotExist = 130008;
    const couponOverdue = 130009;
    const couponNoUsedTicketNum = 130010;
    const alreadyGetTheCoupon = 130011;
    const receiveCouponFailed = 130012;
    const receiveGiftCouponFailed = 130013;
    const receiveGiftCouponUpdateCouponCountFailed = 130014;


    //地址相关错误码
    const emptyAddressId = 140001;
    const addressNotExist = 140002;
    const saveAddressFailed = 140003;
    const currLatLngNoAddress = 140004;
    const emptyParamForMyAddress = 140005;
    const delAddressFailed = 140006;
    const emptyAddressMobile = 140007;
    const chooseAddressFormMap = 140008;
    const wrongAddressMobile = 140009;
    const emptySubAddress = 140010;
    const emptyAddressTrueName = 140011;
    const emptyLatLngParam = 140012;
    const setAddressFailed = 140013;
    const emptyMyAddresses = 140014;
    const wrongAddressGender = 140015;
    const emptyCityCodeForSave = 140016;
    const wrongAccessSetAddress = 140017;
    const emptyProvinceId = 140018;
    const emptyCityId = 140019;
    const emptyDistrictId = 140020;
    const emptyAddressAndName = 140021;
    const wrongAddressTagType = 140022;

    //消息，推送等
    const removeMessage=150001;
    const pushConnectError=152001;
    const pushIsNotOpen=152002;
    const sendMessageFail=152003;
    const sendLimitError=152004;

    const updateReadedError=152005;
    const noExistMessage=152006;
    const noExistButton=152007;
    const isClicked=152008;


    //广告位
    const emptyAdvs = 160001;
    const emptyAdvStore = 160002;


    //个人中心
    const storeEvaNotExist = 170001;
    const ViewTimeNotExist = 170002;
    const cancleCollectionGoods = 170003;
    const cancleCollectionStore= 170004;


//底层异常
    const elasticsError=900001;

















    //分享错误码
    const shareGrowImageError=180001;
    /**
     * 获取错误码配置
     */
    public static function getCodeConfig() {
        return array(
            self::commonError => "请求失败",
            self::paramsError=>"参数有误",
            self::emptyUsername => "用户名不能为空",
            self::emptyPassword=>"密码不能为空",
            self::errorUsernameOrPassword=>'用户名或密码错误',
            self::illegalAccess=>"非法访问,还未授权,或者授权过期",
            self::wrongTelnumber=>"请输入正确的手机号码",
            self::maxGetAccess=>'今天授权次数已经用完',
            self::isLogin=>'你已经登录',
            self::signWrong => '签名错误',
            self::noLogin=>'您还没有登录',
            self::emptyMemberName => '昵称不能为空',
            self::memberNameLengthLimit => '昵称长度必须在1到24个字符之间',
            self::memberBirthdayError => '生日格式错误',
            self::illegalMemberBirthday => '生日不能大于当前日期',
            self::emtpyMemberAvatar => '会员头像不能为空',
            self::saveMemberAvatarFailed => '保存用会员头像失败',
            self::saveMemberFailed => '会员信息保存失败',
            self::saveStoreMemberFailed => '店铺会员关系保存失败',
            self::saveMemberDeviceInfoFailed => '保存会员设备信息失败',
            self::emptyRegisterMobile => '注册时手机号码不能为空',
            self::emptyVerifyCode => '验证码不能为空',
            self::invalidVerifyCode => '验证码是6位有效数字',
            self::emptyDeviceType => '设备类型不能为空',
            self::emptyDeviceUniqueCode => '设备唯一识别码不能为空',
            self::addMemberInfoFailed => '注册保存用户信息失败',
            self::wrongMobileFormat => '手机号码格式错误',
            self::registerMobileExist => '您的手机号码已经存在',
            self::emptyUserType => '用户来源不能为空',
            self::wrongUserType => '用户只能来自微博、QQ、微信',
            self::emptyUserAvatar => '第三方用户头像不能为空',
            self::emptyUserNickname => '第三方用户昵称不能为空',
            self::addMemberMappingError => '添加第三方绑定关系失败',
            self::userAlreadyBind => '当前账号已被其他账号绑定,如需绑定,请先解绑',
            self::emptyPlatformType => '第三方平台类型不能为空',
            self::wrongPlatformInfo => '获取平台授权信息错误',
            self::loginBindUserInfoFailed => '登录是绑定用户信息失败',
            self::cancelBindingUserFailed => '取消第三方绑定失败',
            self::emptyUserOpenid => '第三方用户唯一识别符不能为空',
            self::bindingSuccess => '绑定成功',
            self::memberMobileExist => '您的手机号码不存在对应用户',
            self::checkMobileFailed => '验证手机号码失败',
            self::findPasswordSmsValidFailed => '找回密码验证手机号码失败',
            self::emptyPasswordAndRepassword => '密码和重复密码不能为空',
            self::differentPasswordAndRepassword => '密码和重复密码不一致',
            self::passwordLimit => '密码必须是包含字母和数字的6~12位字符串',
            self::findPasswordLimit => '请先验证手机号码',
            self::setPasswordFailed => '密码设置失败',
            self::emptyOldPassword => '旧密码不能为空',
            self::worngOldPassword => '旧密码错误',
            self::changePasswordFailed => '修改密码失败',
            self::emptyMobile => '手机号码不能为空',
            self::sameWithOldMobile => '手机号码没有发生改变',
            self::changeMobileFailed => '修改手机号码失败',
            self::wxUserInfoAuthError => '小程序微信授权错误',
            self::emptyWxUserInfoAuth => '还没有授权给小程序',
            self::emptyWxOpenid => '微信openid不能为空',
            self::emptyWxInfo => '小程序用户信息不能为空',
            self::wrongWxOpenid => '微信openid错误',
            self::wxAuthInfoLoginFailed => '微信授权登录失败',
            self::emptyOrWrongAuthUserType => '授权用户类型不能为空或者类型错误',
            self::registerMemberFailed => '注册账号失败',
            self::bindingUserNotExist=>'绑定的用户不存在',
            self::emptyMobileForLogin => '登录时手机号码不能为空',
            self::memberExistBindingInfo => '您已经绑定过用户信息,如需绑定,请先解绑',
            self::wrongMemberSex => '会员性别错误',
            self::noAvailForDelMember => '没有删除接口权限',
            self::emptyMobileForDelMember => '删除用户时手机号码不能为空',
            self::emptyMemberForDelMember => '您要删除的用户不存在',
            self::deleteMemberFailed => '删除用户失败',
            self::wxMemberHasBindMobile => '当前用户已经绑定手机号码',
            self::wxMemberBindMobileSendCode => '登录用户才能访问当前接口',
            self::wxMemberBindMobileFailed => '绑定手机失败',
            self::mobileExistMember => '当前手机号码已被其他用户绑定',
            self::emptyEncryptedDataAndVi => '小程序登录时,加密相关参数不能为空(EncryptedDataAndVi)',
            self::getUnionidFailed => '获取unionid失败',
            self::saveMemberMapppingFailed => '保存用户第三方绑定信息失败',
            //商品相关
            self::emptyCommonId=> '商品主键不能为空',
            self::goodsNotExist=> '商品不存在',
            self::groupNotExist=> '组合活动不存在或已下架',

            //订单相关错误
            self::orderNotExist => '订单不存在',
            self::orderError => '订单信息错误',
            self::refundRefuseByStore => '商家不同意退款，如有疑问请联系客服',
            self::returnErrorAfterPay=>'货到付款订单在没确认收货前不能退款退货',
            self::returnBeyondTimeError=>'收货超时订单不能退款',

            //店铺相关错误
            self::illegalFavStore=>'不能关注自己的店铺',
            self::emptyStore=>'店铺不存在或者已关闭',
            self::emptyReportStoreDesc=>'描述内容不能为空',
            self::emptyReportStoreType=>'举报类型不能为空',
            self::emptyStores => '没找到相关店铺',
            self::stroeReceiveError=>'店铺接单错误',

            //购物车相关
            self::wrongCartType => '加入购物车类型不能为空',
            self::emptyAddCartMemberId => '加入购物车时用户必须登录',
            self::emptyCartGoodsId => '加入购物车时商品ID不能为空',
            self::emptyCartGoodsNum => '加入购物车时商品数量不能为空',
            self::emptyCartBlId => '加入购物车时组合销售ID不能为空',
            self::emptyCartBlNum => '加入购物车时组合销售数量不能为空',
            self::noStorageForCart => '商品库存不足',
            self::offlineGoodsOrNotExist => '当前商品不存在或者已下架',
            self::emptyCartBundling => '当前组合销售商品不存在',
            self::cartClosedBundling => '组合销售活动已结束',
            self::lessBundlingNumForCart => '组合销售库存不足',
            self::bundlingGoodsOffline => '组合销售中存在已经下架的商品',
            self::addCartFailed => '加入购物车失败',
            self::lessGoodsNumForCart => '组合销售对应商品库存不足',
            self::emptyMemberCarts => '购物车为空',
            self::overLimitCartCount => '超出购物车数量',
            self::emptyCartById => '不存在对应购物车数据',
            self::unusaulCartForMember => '购物车数据与用户不匹配',
            self::emptyCartId => '购物车ID不能为空',
            self::wrongGoodsForEditCart => '编辑购物车时,商品参数错误',
            self::wrongMemberIdForEditCart => '编辑购物车时,会员ID错误',
            self::editCartFailed => '编辑购物车失败',
            self::delCartFailed => '删除购物车失败',
            self::wrongCartGoodsCommonId => '当前购物车不是普通商品',
            self::emptyCartIdsForDel => '购物车ID不能为空',
            self::wrongCartIdsForDel => '编辑购物车时参数错误',
            self::moveToFavoritesFailed => '移入收藏夹添加数据失败',
            self::moveToFavoritesDelCartFailed => '移入收藏夹删除购物车失败',
            self::emptyCartIdsForCheckout => '购物车下单时购物车ID不能为空',
            self::storeNoDeliveryTypeForBuy =>'店铺没有设置配送方式,不能下单',
            self::storeNoPaywayForBuy => '店铺没有设置支付方式,不能下单',
            self::emptyGoodsIdOrBlIdForBuyNow => '立即购买时商品ID或者组合销售ID不能都为空',
            self::emptyGoodsNumForBuyNow => '立即购买时商品ID或者组合销售ID不能都为空',
            self::wrongBundlingForBuyNow => '没有找到对应组合销售商品',
            self::wrongGoodsForBuyNow => '没有找到对应商品信息或者商品信息已下架',
            self::offlineGoodsListOrNotExist => '存在下架或者不存在的商品',
            self::goodsListNoStorage => '商品库存不足',
            self::emptyPBundlingdForOrder => '组合销售商品不存在',
            self::pBundlingOfflineForOrder => '组合销售商品已经下架',
            self::pBundlingNoStorageForOrder => '组合销售商品库存不足',

            self::addressNotExist=>'地址不存在',
            self::emptyAddressId=>'地址主键参数不能为空',
            self::saveAddressFailed =>'地址保存失败',
            self::currLatLngNoAddress => '当前经纬度不存在收货地址',
            self::emptyParamForMyAddress => '获取地址时参数不能为空',
            self::delAddressFailed  => '地址删除失败',
            self::emptyAddressMobile => '收货地址联系方式不能为空',
            self::chooseAddressFormMap => '请在地图上选择您的收货地址',
            self::wrongAddressMobile => '您输入的联系方式格式不正确',
            self::emptySubAddress => '具体门牌号不能为空',
            self::emptyAddressTrueName => '收货人姓名不能为空',
            self::emptyLatLngParam => '经纬度参数不能为空',
            self::setAddressFailed => '设置当前地址地址',
            self::smsCountLimitOut => '您今日发送此类短信过多',
            self::smsIsSending => '操作过于频繁,请稍后再发送短信',
            self::emptySmsMobile => '获取短信验证码时手机号码不能为空',
            self::emptySmsMessageType => '获取短信验证码是短信验证码类型不能为空',
            self::smsSendFail => '短信发送失败',
            self::emptySmsCode => '短信验证码不能为空',
            self::emptyRedisSmsCode => '没有发送验证码或验证码已过期',
            self::wrongSmsCode => '您的验证码输入有误',
            self::codeIsSixNumberString => '短信验证码是6位数值',
            self::codeIsSixNumberString1 => '短信验证码是61位数值',
            self::removeMessage=>'消息删除失败',
            self::storeNotExistOrClose => '店铺不存在或者已关闭',
            self::emptyStoreId => '店铺ID不能为空',
            self::saveReportError => '保存举报信息失败',
            self::emptyMyAddresses => '我的收货地址为空',
            self::wrongAddressGender => '性别参数错误',
            self::emptyCityCodeForSave => '保存地址市城市编码不能为空',
            self::wrongAccessSetAddress => '设置地址接口调用错误',
            self::emptyProvinceId => '找不到对应省份',
            self::emptyCityId => '找不到对应城市',
            self::emptyDistrictId => '找不到对应区',
            self::emptyAddressAndName => '地址和具体街道不能为空',
            self::wrongAddressTagType => '地址标签传输错误',

            self::emptyLatLng => '经纬度不能为空',
            self::emptyCityCode => '高德地图城市编码不能为空',
            self::emptyGcId => '分类ID不能为空',
            self::emptyStoreIdForOnlineTopClass => '获取店铺一级在售分类时店铺ID不能为空',
            self::emptyStoreIdForOnlineChildrenClass =>'获取店铺下级分类及广告时店铺ID不能为空',
            self::emtpyGcIdForOnlineChildrenClass =>'获取店铺下级分类及广告时分类ID不能为空',
            self::wrongGcIdForStoreIdChildrenClass => '店铺一级分类不能找到对应可售下级分类',

            self::folderUnwritable => '文件夹不可写',
            self::base64ImageError => 'base64图片格式错误',
            self::imageUploadFailed => '图片上传失败',
            self::ossServerSetError => 'OSS服务器配置错误',
            self::emptyImageUrl => '下载图片时路径不能空',
            self::imageExtensionsWrong => '图片格式错误',
            self::emptyImageStr => '图片字符串不能为空',
            //推送
            self::pushConnectError=>'推送连接有误',
            self::pushIsNotOpen=>'推送模块没打开，对方未能及时接收到消息!!!',
            self::noExistMessage=>'消息不存在',
            self::noExistButton=>'不存在此操作按钮',
            self::isClicked=>'此按钮已经点击过了',

            //订单
            self::orderError=>'订单信息错误',
            self::emptyDescCredit=>'店铺描述相符评分不能为空',
            self::emptyDeliveryCredit=>'店铺物流服务评分不能为空',
            self::emptyServiceCredit=>'店铺物流服务评分不能为空',
            self::emptyScores=>'商品评分不能为空',
            self::emptyGoodsId=>'商品id不能为空',


            self::sendMessageFail=>'消息推送失败',
            self::sendLimitError=>'每秒钟只发送一次消息谢谢！',

            self::updateReadedError=>'更新消息为已读失败！',
            self::authError=>'授权参数有误',
            self::authExpire=>'授权过期',
            self::notAllowCancel=>'对不起，当前订单状态不允许取消',
            self::notAllowComplete=>'对不起，当前订单状态不允许确认收货',
            //优惠券
            self::emptyCouponId=>'优惠券ID不能为空',
            self::emptyCouponStoreId => '获取优惠券时店铺ID不能为空',
            self::emptyMemberCouponState => '优惠券状态不能为空',
            self::emptyMemberCouponMemberId => '获取我的优惠券时会员ID不能为空',
            self::couponNotExist => '您领取的优惠券已删除或者过期',
            self::couponOverdue => '当前优惠券已过期',
            self::couponNoUsedTicketNum => '优惠券已经领完了',
            self::alreadyGetTheCoupon => '您已经领过这个优惠券了',
            self::receiveCouponFailed => '领取优惠券失败',
            self::receiveGiftCouponFailed => '赠券保存失败',
            //广告位
            self::emptyAdvs => '广告位内容为空',
            self::emptyAdvStore => '获取店铺广告位时店铺ID不能为空',

            self::storeEvaNotExist=>'卖家评价不存在',
            self::refundSuccess=>'退款成功',
            self::ViewTimeNotExist=>'日期时间戳不能为空',
            self::cancleCollectionGoods=>'取消关注商品参数错误',
            self::cancleCollectionStore=>'取消关注店铺参数错误',
            self::applyError=>'申请平台介入失败',
            self::notReturnAgree=>'卖家未同意退货',
            self::isNotReturn=>'不是退货类型的订单',
            self::isNotExpressType=>'退货方式不是快递',
            self::notExistRefund=>'退款订单不存在',
            self::sendRefundShippingFail=>'添加物流信息失败',
            self::alreadySendRefundShipping=>'退货信息已经提交',

            self::buyerCancelError=>'买家取消订单失败，订单状态有误',
            self::refundCancelError=>'申请退款失败，订单状态有误',
            self::storeCancelError=>'商家取消订单失败，订单状态有误',
            self::systemCancelError=>'平台取消订单失败，订单状态有误',
            self::systemReceivePayError=>'平台收款失败，订单状态有误',
            self::complainError=>'买家投诉失败，订单状态有误',
            self::paymentError=>'支付失败，订单状态有误',
            self::modifyPriceError=>'调整运费失败，订单状态有误',
            self::spayPriceError=>'调整商品价格失败，订单状态有误',
            self::sendError=>'发货失败，订单状态有误',
            self::receiveError=>'收货失败，订单状态有误',
            self::evaluationError=>'评价失败，订单状态有误',
            self::lockError=>'锁定失败，订单状态有误',
            self::deliverError=>'快递跟踪失败，订单状态有误',
            self::notExsitDeliver=>'配送单不存在',
            self::notExsitOrder=>'订单不存在',
            self::alreadyExsitRefundGoods=>'退款订单已经存在',
            self::notAllowDelete=>'当前订单状态不允许删除',
            self::platFormAreadyIn=>'您已经申请过平台介入',
            self::deleteError=>'放入回收站失败，订单状态有误',
            self::restoreError=>'永久删除、从回收站还原失败，订单状态有误',
            self::shareError=>'分享失败，订单状态有误',
            self::orderDeleteError=>'订单删除失败',
            self::noAddressForOrder => '下单前请选择收货地址',
            self::emptyCartIdsForOrder => '下单时购物车ID不能为空',
            self::emptyParamForOrder => '下单时参数不能为空',
            self::emptyStoreIdForOrder => '下单时店铺ID不能为空',
            self::wrongPaywayForOrder => '下单时支付方式错误',
            self::wrongDeliveryTypeForOrder => '下单时配送方式错误',
            self::wrongTimeParamForStoreDelivery => '商家配送订单预计送达时间和配送时间间隔不能为空',
            self::wrongStoreIdsForOrder => '下单时店铺参数错误',
            self::wrongCartStoreForOrder => '下单时店铺购物车ID参数错误',
            self::bundlingGoodsNotExist => '组合销售商品不存在',
            self::noStorageForBundlingGoods => '组合销售商品库存不存在',
            self::bundlingGoodsOfflineForCartOrOrder => '组合销售活动已下架',
            self::goodsNoStoreForCartOrOrder => '商品库存不足',
            self::goodsOfflineForCartOrOrder => '商品已下架',
            self::wrongCouponIdForOrder => '优惠券传参错误',
            self::sameCoupnIdsForOrder => '同一张优惠券不能同时被多家店使用',
            self::wrongCouponForStoreOrder => '该店铺没有可用优惠券,传参错误',
            self::noStoreDeliveryTypeForOrder => '该店铺未配置商家配送',
            self::wrongStoreDeliveryFeeForOrder => '店铺配送费参数错误',
            self::wrongDeliveryTimeRangeForOrder => '下单时配送时间格式',
            self::noBuyerDeliveryTypeForOrder => '该店铺配置到店自提',
            self::noDeliveryFeeForBuyerType => '到店自提不收取配送费',
            self::noExpressDeliveryForOrder => '该店铺未配置快递配送',
            self::wrongPaywayForStoreForOrder => '店铺暂未配置您选择的支付方式',
            self::emptyDeliveryFeeForOrder => '下单时配送费不能为空',
            self::saveOrderPayFailed => '订单支付信息保存失败',
            self::wrongTotalFeeForOrder => '商品价格发生变化,请刷新后重试',
            self::saveOrderFailed => '保存订单失败',
            self::updateMemberCouponFailed => '优惠券更新失败',
            self::updateAddressFailedForOrder => '下单时更新地址失败',
            self::updateGoodsStorageForOrder => '非线上支付订单更新库存失败',
            self::saveOrderCommonFailed => '保存订单相关收货信息失败',
            self::saveOrderGoodsFailed => '保存订单商品失败',
            self::delCartFaileForAddOrder => '下单时删除购物车失败',
            self::orderLogSaveFailedForOrder => '下单时保存订单日志失败',
            self::wrongChannelForPay => '支付渠道错误',
            self::emptyPaySnForPay => '支付订单号错误',
            self::wrongOrderPay => 'paySn错误或已支付',
            self::noOrderListForPay => '要支付的订单不存在',
            self::emptyOrderAmountForPay => '订单金额为0,不能支付',
            self::emptyPaySnForOrder => '支付回调时paySn不能为空',
            self::wrongPaySnForOrder => '支付回调时paySn错误',
            self::updateOrderPayedStatusFailed => '更新订单支付状态失败',
            self::wrongOrderPayForOrder => '您没有当前订单支付状态权限',
            self::emptyOrderForPay => '支付的订单不存在',
            self::emptyOrderIdForPay => '订单ID不能为空',
            self::noRightForOrder => '您没有该订单权限',
            self::wrongPayForOrder => '该订单无需线上支付',
            self::newPaySnInsertFailed => '新订单支付参数生成失败',
            self::updateOrderForPayFailed => '唤起支付时更新订单失败',
            self::noOrderListForPaySn => '当前paySn没有找到对应订单列表',
            self::wrongBlIdAndGoodsIdForOrder => '支付时商品ID或者组合销售ID错误',
            self::emptyGoodsIdOrBlIdForOrder => '支付时商品ID或者组合销售ID不能为空',
            self::emptyGoodsNumForBuyNowOrder => '立即购买下单时商品数量不能为空',
            self::failedUpdateFavoritesStoreForOrder => '更新关注店铺失败',
            self::orderUpdatePaySnFailed => '更新paySn失败',
            self::receiveCouponFailedForOrder => '下单时赠券失败',
            self::blGoodsStorageToDBFailedForOrder => '组合销售库存更新失败(db)',
            self::goodsStorageToDBFailedForOrder => '普通商品库存更新失败(db)',
            self::blGoodsStorageToCacheFailedForOrder => '组合销售库存更新失败(cache)',
            self::goodsStorageToCacheFailedForOrder => '普通商品库存更新失败(cache)',
            self::notExistOrderGoods => '退款商品不存在',
            //销售员
            self::emptySaleGoodsId=>'商品id不能为空',
            self::emptySaleGoods=>'销售商品不存在',
            self::saleNotLogin=>'请先登录',
            self::salePhoneError=>'获取验证码的手机号与用户手机号不一致',
            self::saleNotExist=>'你不是销售员',
            self::saleValidate=>'请先进行身份验证',
            self::saleNotJoin=>'你没有参加这个销售活动',
            self::saleActOrGoodsNotExist=>'活动或商品不存在',
            //意见信箱
            self::emptyFeedbackDescribe => '反馈内容不能为空',
            self::emptyFeedbackTelepone => '联系方式不能为空',
            self::saveFeedbackError=>'保存意见反馈信息失败',
            self::feedbackTelError=>'手机号码格式错误',
            //分享
            self::shareGrowImageError=>'分享图片生成有误',
            self::emptyWxSetting=>'微信小程序未配置',
            self::getWxAccessTokenFail=>'获得微信小程序token失败',
            self::wrongMappingDataForBindMembmer => 'mapping数据错误',
            self::otherMemberOpenIdBindForMember => '当前第三方账号已经绑定其他手机号码的账号',
            self::updateMobileMembmerFailed => '更新手机号对应会员信息失败',
            self::updateMobileMembmerMappingFailed => '更新手机号码对应会员mapping信息失败',
            self::currentMobileHasBeenBind => '当前手机号码已经绑定其他微信,如需绑定,请先手机号码登录app进行微信解绑',
            self::otherDriverLogin=>'当前帐户在其他设备登录，假如不是您本人操作，请尽快修改密码',
            self::elasticsError=>'全文索引连接出错',
            self::emptyLog => '日志内容不能为空',
            self::writeLogFailed => '日志写入失败',
            self::wrongTimeForReadLog => '读日志时写入时间段查询开始时间不能大于结束时间',
            self::saveUserMappingFailed => '保存用户关联关系失败',
            self::registerMemberInfoFailed => '注册更新用户信息失败',
            self::authMemberExistMobile => '该授权用户已经绑定手机号码'
        );
    }

}
