<?php

namespace DAO;



class StoreScoreStatisticsModel extends \DAO\AbstractModel {



    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_store_score_statistics';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'id';
    public function init(){

    }
    public function getOne($field,$where){
        $this->setDb();
        return $this->db->select($field)->from($this->_tableName)->where($where)->fetchOne();
    }
    public function getStoreScoreStatistics($where, $field) {
        $this->setDb();
        return $this->db->select($field)->from($this->_tableName)->where($where)->fetchAll();
    }
    public function insertOrUpdate($data){
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        $baseSql = "insert  into {$this->_tableName}(store_id,evaluation_score,evaluation_number) values({0},{1},{2}) ON DUPLICATE KEY UPDATE evaluation_number = VALUES(evaluation_number),evaluation_score=VALUES(evaluation_score)";
        $sql = \Our\Common::format($baseSql, $data['store_id'], $data['evaluation_score'],$data['evaluation_number']);
        return $this->db->insert($this->_tableName)->query($sql);
    }
    public function insertAllOrUpdate($datas){
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        $error = 0;
        $baseSql = "insert into {$this->_tableName}(store_id,evaluation_score,evaluation_number) values";
        $insertAllSql = $baseSql;
        for ($i = 0; $i < count($datas); $i++) {
            $addSql = \Our\Common::format("({0},{1},{2}),", $datas[$i]['store_id'], $datas[$i]['evaluation_score'], $datas[$i]['evaluation_number']);
            $insertAllSql .= $addSql;
            if ($i % 1000 == 0 && $i != 0) {
                $insertAllSql = rtrim($insertAllSql, ',');
                $insertAllSql .= 'ON DUPLICATE KEY UPDATE num = VALUES(num),updatetime=VALUES(updatetime)';
                $one = $this->db->insert()->query($insertAllSql);
                if ($one === false) {
                    $error++;
                }
                $insertAllSql = $baseSql;
            }
        }
        if ($insertAllSql != $baseSql) {
            $insertAllSql = rtrim($insertAllSql, ',');
            $insertAllSql .= 'ON DUPLICATE KEY UPDATE num = VALUES(num),updatetime=VALUES(updatetime)';
            $one = $this->db->insert($this->_tableName)->query($insertAllSql);
            if ($one === false) {
                $error++;
            }
        }
        if ($error > 0) {
            return false;
        }
        return true;
    }
    /**
     * 获取店铺评分、收藏
     * @param $StoreId
     * @return mixed
     */
    public function getGrade($StoreId, $storeInfo = null)
    {
        $statisticsDb6Redis = \Redis\Db6\StatisticsRedisModel::getInstance();
        $grade = $statisticsDb6Redis->tableHGet('store', $StoreId);
        if ($grade === false) {
            if (!$storeInfo) {
                $storeScoreDAO = \DAO\StoreScoreStatisticsModel::getInstance();
                $storeInfo = \Our\RedisHelper::cachedFunction(\Redis\Db6\StoreScoreStatisticsRedisModel::getInstance(), array(&$storeScoreDAO, 'getOne'), array('*',array('store_id'=>$StoreId)),\Our\ApiConst::oneDaySecond);
                if($storeInfo === false){
                    $storeInfo['evaluation_score'] = 0;
                    $storeInfo['evaluation_number'] = 0;
                }
            }
            $grade = array();
            $grade['evaluation_score'] = $storeInfo['evaluation_score'];
            $grade['evaluation_number'] = $storeInfo['evaluation_number'];
            $statisticsDb6Redis->tableHSet('store', $StoreId, serialize($grade));
            return $grade;
        }
        return unserialize($grade);
    }
    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

}
