<?php

namespace Our;

use Error\CodeConfigModel;
use Error\ErrorModel;

class RedisHelper
{


    /**
     * 对根据参数，对函数的结果进行缓存，一般用于数据库 API 缓存
     *
     * @param const $type 缓存对象
     * @param mixed $function 函数，格式为：'function_name', 或者 array(&$instace, 'method_name')
     * @param array $args 函数参数数组
     * @param number $ttl 过期时间，单位：秒
     * @param array $options 额外参数
     * @throws Exception
     * @return mixed 返回执行 $function 返回的结果
     */

    public static function cachedFunction($cache_instance, $function, array $args = array(), $ttl = 0, array $options = array())
    {
        $serialized_args = serialize($args);
        $function_key = $function;
        if (is_array($function)) {
            if (isset($function[0]) && is_object($function[0]) && isset($function[1])) {
                $function_key = $function[1];
            } else {
                ErrorModel::throwException(CodeConfigModel::commonError);
            }
        }
        $extent_key = '';
        if ($options) {
            $extent_key .= implode(',', $options);
        }
        if (!is_string($function_key)) {
            throw new Exception('非法参数：函数名必须为字符串');
        }
        $cache_key = (is_array($function)
                ? (str_replace('\\', ':', get_class($function[0])) . '_')
                : '') . $function_key . $extent_key . '_' . crc32($serialized_args);
        $result = $cache_instance->tableCacheGet($cache_key);
        if (!empty($result)) {
            return unserialize($result);
        }
        $result = call_user_func_array($function, $args);
        $cache_instance->tableCacheSet($cache_key, serialize($result), $ttl);
        return $result;
    }

    /**
 * 删除缓存如过有传args 就删除指定缓存，如过没有就删除指定对象指定方法为前缀的所有缓存
 *
 * @param const $type 缓存对象
 * @param mixed $function 函数，格式为：'function_name', 或者 array(&$instace, 'method_name')
 * @param array $args 函数参数数组
 * @param number $ttl 过期时间，单位：秒
 * @param array $options 额外参数
 * @throws Exception 
 * @return mixed 返回执行 $function 返回的结果
 */
    public static function delCachedFunction($cache_instance, $function, array $args = array(), array $options = array())
    {
        $serialized_args = serialize($args);
        $function_key = $function;
        if (is_array($function)) {
            if (isset($function[0]) && is_object($function[0]) && isset($function[1])) {
                $function_key = $function[1];
            } else {
                throw new Exception("非法参数：\$function 必须为函数名，或者是 array(\$class_instance, \$funcion_name) 的格式");
            }
        }
        $extent_key = '';
        if ($options) {
            $extent_key .= implode(',', $options);
        }
        if (!is_string($function_key)) {
            throw new Exception('非法参数：函数名必须为字符串');
        }
        if (empty($args)) {
            $cache_key = (is_array($function)
                    ? (str_replace('\\', ':', get_class($function[0])) . '_')
                    : '') . $function_key . $extent_key.'_';
            $res = $cache_instance->tableDelAll($cache_instance->tableKeys($cache_key));
        } else {
            $cache_key = (is_array($function)
                    ? (str_replace('\\', ':', get_class($function[0])) . '_')
                    : '') . $function_key . $extent_key . '_' . crc32($serialized_args);
            $res = $cache_instance->tableDel($cache_key);
        }
       
       
       
        return $res;
    }

    /**
     * 判断key是否存在
     * @param $cache_instance
     * @param $function
     * @param array $args
     * @param array $options
     * @return mixed
     */
    public static function cachedFunctionExist($cache_instance, $function, array $args = array(), array $options = array())
    {
        $serialized_args = serialize($args);
        $function_key = $function;
        if (is_array($function)) {
            if (isset($function[0]) && is_object($function[0]) && isset($function[1])) {
                $function_key = $function[1];
            } else {
                ErrorModel::throwException(CodeConfigModel::commonError);
            }
        }
        $extent_key = '';
        if ($options) {
            $extent_key .= implode(',', $options);
        }
        if (!is_string($function_key)) {
            throw new Exception('非法参数：函数名必须为字符串');
        }
        $cache_key = (is_array($function)
                ? (str_replace('\\', ':', get_class($function[0])) . '_')
                : '') . $function_key . $extent_key . '_' . crc32($serialized_args);
        return $cache_instance->tableKeyExists($cache_key);
    }

    /**
     * 设置缓存
     * @param $cache_instance
     * @param $function
     * @param array $args
     * @param int $ttl
     * @param array $options
     * @param $value
     * @return bool
     * @throws \Exception
     */
    public static function setCachedFunction($cache_instance, $function ,$value, array $args = array(), $ttl = 0, array $options = array())
    {
        $serialized_args = serialize($args);
        $function_key = $function;
        if (is_array($function)) {
            if (isset($function[0]) && is_object($function[0]) && isset($function[1])) {
                $function_key = $function[1];
            } else {
                ErrorModel::throwException(CodeConfigModel::commonError);
            }
        }
        $extent_key = '';
        if ($options) {
            $extent_key .= implode(',', $options);
        }
        if (!is_string($function_key)) {
            throw new Exception('非法参数：函数名必须为字符串');
        }
        $cache_key = (is_array($function)
                ? (str_replace('\\', ':', get_class($function[0])) . '_')
                : '') . $function_key . $extent_key . '_' . crc32($serialized_args);
        $result = $cache_instance->tableCacheGet($cache_key);
        if (!$value) {
            return false;
        }
        $cache_instance->tableCacheSet($cache_key, serialize($value), $ttl);
        return $result;
    }
    /**
     * 删除缓存如过有传args 就删除指定缓存，如过没有就删除指定对象指定方法为前缀的所有缓存
     *
     * @param const $type 缓存对象
     * @param mixed $function 函数，格式为：'function_name', 或者 array(&$instace, 'method_name')
     * @param array $args 函数参数数组
     * @param number $ttl 过期时间，单位：秒
     * @param array $options 额外参数
     * @throws Exception
     * @return mixed 返回执行 $function 返回的结果
     */
    public static function memberTotalFromStateToState($memberId, $fromState, $toState)
    {
        $memberDao=\DAO\MemberModel::getInstance(DbNameConst::masterDBConnectName);
        return $memberDao->fromOrderStateToOrderState($memberId,$fromState,$toState);
    }



}
