<?php
namespace Payment;
/**
 * 微信支付
 * User: liuyuzhen
 * Date: 2018/7/3
 * Time: 9:24
 * Description:
 */

class WxPay extends \Payment\TencentPay
{

    private $refundUrl="https://api.mch.weixin.qq.com/secapi/pay/refund";
    public function __construct()
    {
        $this->appid = \Our\PayConst::wxPayAppId;
        $this->notify_url = \Our\Common::getBaseUrl().\Our\PayConst::wxAppNotifyUrl;
        $this->mch_id = \Our\PayConst::wxPayMchId;
        $this->key = \Our\PayConst::wxPayKey;
        $this->sslcert_path = \Our\PayConst::wxSslcertPath;
        $this->sslkey_path = \Our\PayConst::wxSslkeyPath;
        $this->pay_url = \Our\PayConst::wxPayUrl;
        $this->tradeType = \Our\PayConst::wxAppTradeType;
        $this->s_mch_id =  \Our\PayConst::wxSPayMchId;
        $this->s_key =  \Our\PayConst::wxSPayKey;
        $this->s_appid =  \Our\PayConst::wxSPayAppId;
        $this->s_notify_url = \Our\Common::getBaseUrl().\Our\PayConst::wxAppNotifyUrlService;
    }

    public function doPay($orderInfo)
    {
        if(isset($orderInfo['subMchId'])){
            $this->setServiceRequestParams($orderInfo);
        }else{
            $this->setRequestParams($orderInfo);
        }
        $wxAppParameters = $this->getParameters();
        $returnData = array(
            'credential' => array(\Our\NameConst::wxAppChannel => $wxAppParameters),
            'app_id' => $this->appid
        );
        return $returnData;
    }

    /**
     *    作用：设置APP支付的参数
     */
    public function getParameters()
    {
        $wxApiObj["appid"] = $this->appid;
        $timeStamp = TIMESTAMP;
        $wxApiObj['partnerid'] = $this->mch_id;
        $wxApiObj["timestamp"] = "$timeStamp";
        $wxApiObj["noncestr"] = \Our\CommonExtension::createNoncestr();
        $wxApiObj["package"] = "Sign=WXPay";
        $wxApiObj['prepayid'] = $this->prepay_id;
        $wxApiObj["sign"] = $this->getSign($wxApiObj);
        return $wxApiObj;
    }


    public function refund($param){
        return $this->serviceRefund($param);
//        if($param['subMchId']){
//            return $this->serviceRefund($param);
//        }else{
//           return  $this->commonRefund($param);
//        }
    }

    public function serviceRefund($param){
        $this->key = $this->s_key;
        $this->sslcert_path =  \Our\PayConst::wxServiceSslcertPath;
        $this->sslkey_path = \Our\PayConst::wxServiceSslkeyPath;
        $total_fee = intval($param['totalFee']);
        $refund_fee = intval($param['refundFee']);
        if(APP_ENV == 'develop'||APP_ENV == 'test'||APP_ENV == 'pre' || APP_ENV=='ccwdevelop'){
            $this->parameters['total_fee'] = 1;
            $this->parameters['refund_fee'] = 1;
        } else {
            $this->parameters['total_fee'] = $total_fee;
            $this->parameters['refund_fee'] = $refund_fee;
        }
        $this->parameters['out_refund_no'] = $param['refundOrderNo'];
        $this->parameters['out_trade_no'] = $param['outTradeNo'];
        $this->parameters['op_user_id'] = $this->mch_id;
        $this->parameters['nonce_str'] = $this->createNoncestr(32);
        $this->parameters['appid'] = \Our\PayConst::wxSPayAppId;
        $this->parameters['mch_id'] = \Our\PayConst::wxSPayMchId;
        $this->parameters['sub_appid'] = \Our\PayConst::wxSPayAppId;
        $this->parameters['sub_mch_id '] = $param['subMchId'];
        $xml = $this->createXml();
        $response = $this->postXmlSSLCurl($xml, $this->refundUrl, 6);
        $values = $this->xmlToArray($response);
        if ($values['return_code'] != 'SUCCESS') {
            return $values;
        }
        $this->checkSign($values);
        return $values;
    }

    public function commonRefund($param)
    {
        $total_fee = intval($param['totalFee']);
        $refund_fee = intval($param['refundFee']);
        if(APP_ENV == 'develop'||APP_ENV == 'test'||APP_ENV == 'pre' || APP_ENV=='ccwdevelop'|| APP_ENV=='lyztest'){
            $this->parameters['total_fee'] = 1;
            $this->parameters['refund_fee'] = 1;
        } else {
            $this->parameters['total_fee'] = $total_fee;
            $this->parameters['refund_fee'] = $refund_fee;
        }
        $this->parameters['out_refund_no'] = $param['refundOrderNo'];
        $this->parameters['out_trade_no'] = $param['outTradeNo'];
        $this->parameters['op_user_id'] = $this->mch_id;
        $this->parameters['nonce_str'] = $this->createNoncestr(32);
        $this->parameters['appid'] = \Our\PayConst::wxPayAppId;
        $this->parameters['mch_id'] = \Our\PayConst::wxPayMchId;
        $xml = $this->createXml();
        $response = $this->postXmlSSLCurl($xml, $this->refundUrl, 6);
        $values = $this->xmlToArray($response);
        if ($values['return_code'] != 'SUCCESS') {
            return $values;
        }
        $this->checkSign($values);
        return $values;
    }

    /**
     * 类实例
     *
     */
    private static $_instance = null;

    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance()
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

}
