<?php

namespace DAO\Order;

use OSS\Common;
use Our\ApiConst;
use Our\DbNameConst;
use Our\DescribeConst;
use Our\ImageConst;
use Our\OrderConst;


/**
 * 订单相关
 * @date 2018-5-14
 * @author csw
 */
class DiliverymanModel extends \DAO\AbstractModel
{


    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_diliveryman';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'id';

    public function init()
    {
        //$this->setDb();
    }


    public function getCount($where, $isArray = true)
    {
        $this->setDb();
        if (!$isArray) {
            $str = '$count =  $this->db->from($this->_tableName)';
            foreach ($where as $v) {
                $str .= "->where('$v')";
            }
            $str .= "->fetchNum();";
            eval($str);
            return $count;
        }
        return $this->db->from($this->_tableName)->where($where)->fetchNum();
    }

    /**
     * 获取单条数据
     * @param $where
     * @return array
     */
    public function find($where)
    {
        $data = $this->db->from($this->_tableName)->where($where)->fetchOne();
        return $data;
    }

    public function findById($id)
    {
        $this->setDb($this->dbName);
        $where[$this->_primaryKey] = $id;
        return $this->find($where);
    }

    public function convert($info,$keyValues,$imageField='qrcode_path'){
        $convertInfo=array();
        foreach($keyValues as $key =>$val){
            if($key!=$imageField){
                $convertInfo[$val]=$info[$key];
            }else{
                $convertInfo[$val]=\Our\Common::getStaticFile($info[$key],ImageConst::memberAvatar) ;
            }
        }
        return $convertInfo;
    }


    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */

    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance($dbName=DbNameConst::salveDBConnectName)
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }

}
