<?php

namespace DAO\Order;

use Our\ApiConst;


/**
 * 订单相关
 * @date 2018-5-14
 * @author csw
 */
class OrderCommonModel extends \DAO\AbstractModel
{


    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_order_common';


    protected $apiReceiverInfo;
    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'order_id';
    public $orderCommonField = "order_id as orderId, reciver_name as reciverName,reciver_info as reciverInfo,daddress_id as daddressId,order_message as orderMessage,shipping_time as shippingTime";
    public function init()
    {
        //$this->setDb();
    }

    public function getShippingFields(){
        return "order_id as orderId,shipping_express_id as shippingExpressId";
    }
    /**
     * 获取单条数据
     * @param $where
     * @return array
     */
    public function find($where, $field = '*')
    {
        $data = $this->db->from($this->_tableName)->select($field)->where($where)->fetchOne();
        return $data;
    }

    public function findByOrderId($orderId, $field = '*')
    {
        $this->setDb($this->dbName);
        $where[$this->_primaryKey] = $orderId;
        return $this->find($where, $field);
    }

    //根据订单id 获取
    public function getAllByOrderIds($orderIds, $field = '*', $fieldId = false)
    {
        $this->setDb($this->dbName);
        if (is_array($orderIds)) {
            $where['order_id'] = array('in', $orderIds);
        } else {
            $where['order_id'] = $orderIds;
        }
        $where = $this->db->getSqlWhereByArray($where);
        $res = $this->db->from($this->_tableName)->select($field)->where($where)->fetchAll();
        if ($res && $fieldId) {
            $res = array_column($res,'shippingExpressId','orderId');
        }
        return $res;
    }

    public function getAllByOrderIdsCache($orderIds, $deliveryId, $field = '*')
    {
        return \Our\RedisHelper::cachedFunction(\Redis\Db5\OrderRedisModel::getInstance(), array(&$this, 'getAllByOrderIds'), array($orderIds, $field), ApiConst::oneDaySecond, array($deliveryId));
    }

    public function insert($data)
    {
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        $result = $this->db->insert($this->_tableName)->rows($data)->execute();
        return $result;
    }
    /**
     * 更新数据
     * @param $data
     * @param $where
     * @return mixed
     */
    public function update($where, $data)
    {
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        return $this->db->update($this->_tableName)->where($where)->rows($data)->execute();
    }


    public function insertAll($datas)
    {
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        $error = 0;
        $baseSql = "insert IGNORE into {$this->_tableName}(order_id,store_id,order_message,reciver_info,reciver_name,reciver_city_id) values";
        $insertAllSql = $baseSql;
        for ($i = 0; $i < count($datas); $i++) {
            $addSql = \Our\Common::format("('{0}','{1}','{2}','{3}','{4}','{5}'),", $datas[$i]['order_id'], $datas[$i]['store_id'], $datas[$i]['order_message'], $datas[$i]['reciver_info'], $datas[$i]['reciver_name'], $datas[$i]['reciver_city_id']);
            $insertAllSql .= $addSql;
            if ($i % 1000 == 0 && $i != 0) {
                $insertAllSql = rtrim($insertAllSql, ',');
                $one = $this->db->insert($this->_tableName)->query($insertAllSql);
                if (!$one) {
                    $error++;
                }
                $insertAllSql = $baseSql;
            }
        }
        if ($insertAllSql != $baseSql) {
            $insertAllSql = rtrim($insertAllSql, ',');
            $one = $this->db->insert($this->_tableName)->query($insertAllSql);

            if (!$one) {
                $error++;
            }
        }
        if ($error > 0) {
            return false;
        }
        return true;
    }
   public function getReciverInfo($receiverInfo){
       if(!empty($receiverInfo)){
           $apiReceiverInfoDao=\DAO\Order\ApiReciverInfoModel::getInstance();
           $apiReceiverInfoDao->convertReceiverInfo($receiverInfo);
           return $apiReceiverInfoDao->getReceiverInfo();
       }else{
           return new \stdClass();
       }
   }
    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;


    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance($dbName = \Our\DbNameConst::salveDBConnectName)
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }

}
