<?php

namespace DAO\Order;

use OSS\Common;
use Our\ApiConst;
use Our\DbNameConst;
use Our\DescribeConst;
use Our\ImageConst;
use Our\OrderConst;


/**
 * 订单相关
 * @date 2018-5-14
 * @author csw
 */
class DiliverymanModel extends \DAO\AbstractModel
{

    public $detailField='id as id,true_name as trueName,mobile as mobile,scores as scores,store_id as storeId,add_time as addTime,update_time as updateTime,member_id as memberId,bind_status as bindStatus,is_del as isDel';
    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_diliveryman';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'id';

    public function init()
    {
        //$this->setDb();
    }


    public function getCount($where, $isArray = true)
    {
        $this->setDb();
        if (!$isArray) {
            $str = '$count =  $this->db->from($this->_tableName)';
            foreach ($where as $v) {
                $str .= "->where('$v')";
            }
            $str .= "->fetchNum();";
            eval($str);
            return $count;
        }
        return $this->db->from($this->_tableName)->where($where)->fetchNum();
    }

    /**
     * 获取单条数据
     * @param $where
     * @return array
     */
    public function find($where)
    {
        $data = $this->db->from($this->_tableName)->select($this->detailField)->where($where)->fetchOne();
        return $data;
    }
    //任务脚本方法
    public function getListByMemberId($memberId)
    {
        $this->setDb($this->dbName);
        $where['member_id']=$memberId;
        $where['is_del']=ApiConst::zero;
        $where = $this->db->getSqlWhereByArray($where);
        $list = $this->db->select($this->detailField)->from($this->_tableName)->where($where)->fetchAll();
        return $list;
    }
    public function findById($id)
    {
        $this->setDb($this->dbName);
        $where[$this->_primaryKey] = $id;
        return $this->find($where);
    }
    public function getDeliveryManFields()
    {
        return array(
            'qrcode_path' => 'qrcodePath',
            'true_name' => 'trueName',
            'mobile' => 'mobile',
        );
    }
    public function convert($info){
        $memberDao=\DAO\MemberModel::getInstance();
        $info['qrcodePath']=$memberDao->getMemberAvatar($info['memberId']);
        return $info;
    }
    public function getByWhere($where)
    {
        $this->setDb($this->dbName);
        if(is_array($where)){
            $where = $this->db->getSqlWhereByArray($where);
        }
        $list = $this->db->select($this->detailField)->from($this->_tableName)->where($where)->fetchAll();
        return $list;
    }
    public function getDeliveryManByStoreId($storeId){
        $where['store_id']=$storeId;
        return $this->getByWhere($where);
    }


    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */

    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance($dbName=DbNameConst::salveDBConnectName)
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }

}
