/* Filename:	ICK.H
   Description: to define all structrues and prototype for ICK
   Author:		yanghx (yanghx@infosec.com.cn)
   Copyright:	Infosec 2002
   History:		created  by yanghx 2002.4
				modified by yanghx 2002.5
*/ 

#ifndef __ICK_H__
#define __ICK_H__ 1

#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif

#if  defined (_WIN32)
#include <windows.h>		/* windows.h is necessary for HINSTANCE */
typedef HINSTANCE   P11_LIB_HANDLE;
#else
#include <dlfcn.h>			/* dlfcn.h is necessary for loading .so library */
typedef void*   P11_LIB_HANDLE;
#endif

#define _FOR_OWN_USE_

#if defined(_WIN32)	
	#if defined( _DLLEXPORT_ )
		#define ICK_DLLENTRY	__declspec(dllexport)
	#else
		#define ICK_DLLENTRY	//__declspec(dllimport)
	#endif
#else
	#define ICK_DLLENTRY
#endif

typedef  int  ( *KI_FUNC_PTR ) (unsigned char**);
typedef  int  ( *AI_FUNC_PTR ) (unsigned char**);

#include "types.h"

/************************************************************************/
/*				 define error returning code below                      */
/************************************************************************/
/* These error code must be negative.
 */
#define OK						 0
#define ICK_SUCCESS		         0
#define ICK_ERR_MALLOC			-1
#define ICK_ERR_BAD_INPUT_PARA	-2
#define ICK_ERR_BAD_INPUT_LEN	-3
#define ICK_ERR_KEY_NOT_SET		-4
#define ICK_ERR_ALG_NOT_SET		-5
#define ICK_ERR_ALG_NOT_SUPPORT -6
#define	ICK_ERR_WRONG_KEY_INFO	-7
#define	ICK_ERR_WRONG_ALG_INFO	-8
#define ICK_ERR_LIB				-9
#define ICK_ERR_MPI				-10
#define ICK_ERR_GEN_KEY_PAIR	-11
#define ICK_ERR_RSA				-12
#define ICK_BAD_SIGN			-13
#define	ICK_ERR_BAD_RSA_KEY		-14
#define	ICK_ERR_CREATE_CHOOSER	-15
#define ICK_ERR_GET_ATTRUBUTE	-16
#define ICK_ERR_INIT			-17
#define ICK_ERR_FREE			-18
#define ICK_ERR_FIND_OBJECT		-19

#define ICK_MAXERR              -32

#define ICK_DEBUG

/*  Version information. */
static char * ICK_VERSION = (char*)"Infosec Cryptography Kits Version 0.99";

extern P11_LIB_HANDLE hLibHandle;
extern long			  slotID;

#define UNUSED_ARG(x) x = *(&x);

#ifdef _OLD_COMPILER
 #define PROTO_LIST(list)    ()
#else
 #define PROTO_LIST(list)    list
#endif

#undef   NULL_PTR
#define	 NULL_PTR 0

#undef   TRUE
#undef   FALSE
#define  TRUE  1
#define  FALSE 0	

typedef POINTER B_KEY_OBJ;

typedef POINTER	B_ALGORITHM_OBJ;

typedef POINTER B_ALGORITHM_CHOOSER;

/******************************************************************************/
/*  Now define the all B_xxxxxx functions of  infosec cryptograpthy toolkits  */
/******************************************************************************/
/* functions to deal with key object. 
 */
ICK_DLLENTRY int   B_Initialize(char *libName,char *label,char *password);
ICK_DLLENTRY int   B_Finalize(void);

ICK_DLLENTRY int   B_CreateKeyObject  PROTO_LIST ((B_KEY_OBJ *));
ICK_DLLENTRY void  B_DestroyKeyObject PROTO_LIST ((B_KEY_OBJ *));
ICK_DLLENTRY int   B_SetKeyInfo PROTO_LIST ((B_KEY_OBJ, KI_FUNC_PTR, POINTER));
ICK_DLLENTRY int   B_GetKeyInfo PROTO_LIST ((POINTER *, B_KEY_OBJ, KI_FUNC_PTR));

/* functions to deal with algorithm object.
 */
ICK_DLLENTRY int   B_CreateAlgorithmObject PROTO_LIST ((B_ALGORITHM_OBJ *));
ICK_DLLENTRY void  B_DestroyAlgorithmObject PROTO_LIST ((B_ALGORITHM_OBJ *));
ICK_DLLENTRY int   B_SetAlgorithmInfo PROTO_LIST ((B_ALGORITHM_OBJ, AI_FUNC_PTR, POINTER));
ICK_DLLENTRY int   B_GetAlgorithmInfo PROTO_LIST ((POINTER *, B_ALGORITHM_OBJ, AI_FUNC_PTR));

/* functions to deal with all kinds of operations.
 */
ICK_DLLENTRY int  B_DigestInit PROTO_LIST   ((B_ALGORITHM_OBJ, B_ALGORITHM_CHOOSER));
ICK_DLLENTRY int  B_DigestUpdate PROTO_LIST ((B_ALGORITHM_OBJ, BYTE *, UINT4));
ICK_DLLENTRY int  B_DigestFinal PROTO_LIST  ((B_ALGORITHM_OBJ, BYTE*,  UINT4*));
ICK_DLLENTRY int  B_Digest PROTO_LIST		((B_ALGORITHM_OBJ, BYTE *, UINT4, BYTE*, UINT4*));

ICK_DLLENTRY int  B_EncryptInit PROTO_LIST   ((B_ALGORITHM_OBJ, B_KEY_OBJ, B_ALGORITHM_CHOOSER));
ICK_DLLENTRY int  B_EncryptUpdate PROTO_LIST ((B_ALGORITHM_OBJ, BYTE*, UINT4,BYTE *, UINT4*));
ICK_DLLENTRY int  B_EncryptFinal PROTO_LIST  ((B_ALGORITHM_OBJ, BYTE *, UINT4*));
ICK_DLLENTRY int  B_Encrypt PROTO_LIST		 ((B_ALGORITHM_OBJ, BYTE *, UINT4, BYTE*, UINT4*));

ICK_DLLENTRY int  B_DecryptInit PROTO_LIST   ((B_ALGORITHM_OBJ, B_KEY_OBJ, B_ALGORITHM_CHOOSER));
ICK_DLLENTRY int  B_DecryptUpdate PROTO_LIST ((B_ALGORITHM_OBJ, BYTE*, UINT4,BYTE *, UINT4 *));
ICK_DLLENTRY int  B_DecryptFinal PROTO_LIST  ((B_ALGORITHM_OBJ, BYTE *, UINT4 *));
ICK_DLLENTRY int  B_Decrypt PROTO_LIST		 ((B_ALGORITHM_OBJ, BYTE *, UINT4, BYTE*, UINT4*));

ICK_DLLENTRY int  B_SignInit PROTO_LIST   ((B_ALGORITHM_OBJ, B_KEY_OBJ, B_ALGORITHM_CHOOSER));
ICK_DLLENTRY int  B_SignUpdate PROTO_LIST ((B_ALGORITHM_OBJ, BYTE *, UINT4));
ICK_DLLENTRY int  B_SignFinal PROTO_LIST  ((B_ALGORITHM_OBJ, BYTE *, UINT4*));
ICK_DLLENTRY int  B_Sign PROTO_LIST		  ((B_ALGORITHM_OBJ, BYTE *, UINT4,	BYTE *,	UINT4 *));

/* added by yhx on 2002/1/17 */
ICK_DLLENTRY int  B_SignRecoverInit PROTO_LIST ((B_ALGORITHM_OBJ, B_KEY_OBJ, B_ALGORITHM_CHOOSER));
ICK_DLLENTRY int  B_SignRecover PROTO_LIST  ((B_ALGORITHM_OBJ, BYTE *, UINT4,	BYTE *,	UINT4 *));
ICK_DLLENTRY int  B_VerifyRecoverInit PROTO_LIST ((B_ALGORITHM_OBJ, B_KEY_OBJ, B_ALGORITHM_CHOOSER));
ICK_DLLENTRY int  B_VerifyRecover PROTO_LIST  ((B_ALGORITHM_OBJ, BYTE *, UINT4,	BYTE *,	UINT4 *));
// end 2002/1/17 's modification

ICK_DLLENTRY int  B_VerifyInit   PROTO_LIST ((B_ALGORITHM_OBJ, B_KEY_OBJ, B_ALGORITHM_CHOOSER));
ICK_DLLENTRY int  B_VerifyUpdate PROTO_LIST ((B_ALGORITHM_OBJ, BYTE *, UINT4));
ICK_DLLENTRY int  B_VerifyFinal  PROTO_LIST ((B_ALGORITHM_OBJ, BYTE *, UINT4));
ICK_DLLENTRY int  B_Verify		 PROTO_LIST	((B_ALGORITHM_OBJ, BYTE *, UINT4, BYTE *, UINT4));

ICK_DLLENTRY int  B_RandomInit PROTO_LIST ((B_ALGORITHM_OBJ, B_ALGORITHM_CHOOSER, BYTE *, UINT4 ));
ICK_DLLENTRY int  B_Random PROTO_LIST  ((B_ALGORITHM_OBJ, BYTE *, UINT4));

ICK_DLLENTRY int  B_GenerateKeypairInit PROTO_LIST ((B_ALGORITHM_OBJ, B_ALGORITHM_CHOOSER));
ICK_DLLENTRY int  B_GenerateKeypair PROTO_LIST((B_ALGORITHM_OBJ, B_KEY_OBJ, ITEM, B_KEY_OBJ, ITEM, BOOL));

ICK_DLLENTRY int  B_SymmetricKeyGenerateInit PROTO_LIST ((B_ALGORITHM_OBJ, B_ALGORITHM_CHOOSER));
ICK_DLLENTRY int  B_SymmetricKeyGenerate PROTO_LIST ((B_ALGORITHM_OBJ, B_KEY_OBJ));

ICK_DLLENTRY int  B_CreateHardwareChooser  PROTO_LIST ((B_ALGORITHM_CHOOSER currentChooser, B_ALGORITHM_CHOOSER *newChooser,B_INFO_TYPE hwInfoType,POINTER info));
ICK_DLLENTRY int  B_DestroyHardwareChooser PROTO_LIST ((B_ALGORITHM_CHOOSER *chooser));

//ICK_DLLENTRY int  B_GetDevice PROTO_LIST ((ITEM *device, B_ALGORITHM_OBJ algorithmObject));

/* 
	the routines below added on 2002.9.18 for finding public key  
 */
ICK_DLLENTRY int  B_GetPublicKey	PROTO_LIST ((B_ALGORITHM_CHOOSER chooser, ITEM label, POINTER pubKey, ULONG *handle));

ICK_DLLENTRY int  B_GetPrivateKey	PROTO_LIST ((B_ALGORITHM_CHOOSER chooser, ITEM label, POINTER pubKey, ULONG *handle));
ICK_DLLENTRY int  B_SetPrivateKey	PROTO_LIST ((B_ALGORITHM_CHOOSER chooser, ITEM label, POINTER pubKey));

ICK_DLLENTRY int  B_GetCertificate  PROTO_LIST ((B_ALGORITHM_CHOOSER chooser, ITEM label, ITEM *x509Certificate, ULONG *handle));
ICK_DLLENTRY int  B_SetCertificate  PROTO_LIST ((B_ALGORITHM_CHOOSER chooser, ITEM label, ITEM x509Certificate));

/******************************************************************************/
/* Define ber en/decode functions prototype in infosec cryptograpthy toolkits */
/******************************************************************************/
ICK_DLLENTRY int  B_EncodeDigestInfo PROTO_LIST ((BYTE *, UINT4 *, UINT4, ITEM *, BYTE *,UINT4));
ICK_DLLENTRY int  B_DecodeDigestInfo PROTO_LIST ((ITEM *, ITEM *, BYTE *, UINT4));

/******************************************************************************/
/*  Define all KI_XXXX functions prototype in infosec cryptograpthy toolkits  */
/******************************************************************************/

/* KI_Token was used to get key resided in hardware */
ICK_DLLENTRY int  KI_Token PROTO_LIST ((POINTER *));

/* KI_SSF33 was added 2002.8. */
ICK_DLLENTRY int  KI_Generic PROTO_LIST ((POINTER *));

ICK_DLLENTRY int  KI_SSF33 PROTO_LIST ((POINTER *));

ICK_DLLENTRY int  KI_DES8 PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  KI_DES24Strong PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  KI_DESX PROTO_LIST ((POINTER *));

ICK_DLLENTRY int  KI_PKCS_RSAPrivate PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  KI_RSAPublic PROTO_LIST ((POINTER *));

ICK_DLLENTRY int  KI_RC2  PROTO_LIST ((POINTER *ptr));
ICK_DLLENTRY int  KI_RC5  PROTO_LIST ((POINTER *ptr));
ICK_DLLENTRY int  KI_RC4  PROTO_LIST ((POINTER *ptr));

/******************************************************************************/
/*  Define all AI_XXXX functions prototype in infosec cryptograpthy toolkits  */
/******************************************************************************/
ICK_DLLENTRY int  AI_SSF33_CBC_IV16 PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_SSF33_CBCPadIV16 PROTO_LIST ((POINTER *));

ICK_DLLENTRY int  AI_DES_CBC_IV8 PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_DES_CBCPadIV8 PROTO_LIST ((POINTER *));

ICK_DLLENTRY int  AI_DES3_EDE_CBC_IV8 PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_DES3_EDE_CBCPadIV8 PROTO_LIST ((POINTER *));
 
ICK_DLLENTRY int  AI_HMAC PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_KeypairGen PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_KeypairTokenGen PROTO_LIST ((POINTER *));

ICK_DLLENTRY int  AI_MD2 PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_MD2Random PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_MD2WithDES_CBCPad PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_MD2WithRC2_CBCPad PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_MD2WithRSAEncryption PROTO_LIST ((POINTER *));

ICK_DLLENTRY int  AI_MD5 PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_MD5Random PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_MD5WithDES_CBCPad PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_MD5WithRC2_CBCPad PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_MD5WithRSAEncryption PROTO_LIST ((POINTER *));

ICK_DLLENTRY int  AI_SHA1 PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_SHA1Random PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_SHA1WithDES_CBCPad PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_SHA1WithRSAEncryption PROTO_LIST ((POINTER *));

/* PKCS OAEP added for next version */
ICK_DLLENTRY int  AI_PKCS_OAEPRecode PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_PKCS_OAEP_RSAPublic PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_PKCS_OAEP_RSAPrivate PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_PKCS_RSAPrivate PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_SET_OAEP_RSAPrivate PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_PKCS_RSAPublic PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_SET_OAEP_RSAPublic PROTO_LIST ((POINTER *));

ICK_DLLENTRY int  AI_RC2_CBC PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_RC2_CBCPad PROTO_LIST ((POINTER *));

ICK_DLLENTRY int  AI_RC4 PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_RC4WithMAC PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_RC5_CBC PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_RC5_CBCPad PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_RC6_CBC PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_RC6_CBCPad PROTO_LIST ((POINTER *));

ICK_DLLENTRY int  AI_RSAKeyGen PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_RSAStrongKeyGen PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_SignVerify PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_RSAPrivate PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_RSAPublic PROTO_LIST ((POINTER *));

ICK_DLLENTRY int  AI_SymKeyTokenGen PROTO_LIST ((POINTER *));
ICK_DLLENTRY int  AI_SymKeyGen PROTO_LIST ((POINTER *ptr));

/******************************************************************************/
/*   the only HI_XXXX function prototype in infosec cryptograpthy toolkits    */
/******************************************************************************/
ICK_DLLENTRY int  HI_PKCS11Session PROTO_LIST ((POINTER *));

/******************************************************************************/
/*     define the base operation functions                                    */
/******************************************************************************/
ICK_DLLENTRY void   ICK_memset (void*, int, unsigned int);

ICK_DLLENTRY void   ICK_memcpy (void *,  const void*, unsigned int);

ICK_DLLENTRY void   ICK_memmove(void*, const void*, unsigned int);

ICK_DLLENTRY int    ICK_memcmp (const void*, const void*, unsigned int);

ICK_DLLENTRY void*  ICK_malloc (unsigned int);

ICK_DLLENTRY void*  ICK_realloc(void*, unsigned int);

ICK_DLLENTRY void   ICK_free (void*);

ICK_DLLENTRY void   ICK_strcpy  (char *, char *);

ICK_DLLENTRY int    ICK_strcmp (char *, char *);

ICK_DLLENTRY unsigned long ICK_time(long *);

ICK_DLLENTRY unsigned int  ICK_strlen (char *);

ICK_DLLENTRY void  ICK_log (char *fmt , ... );

ICK_DLLENTRY void  ICK_PrintBuf (char *, unsigned char *, unsigned int );
	
#define M_RC2_KEY_GEN                0x00000100
#define M_RC4_KEY_GEN                0x00000110
#define M_DES_KEY_GEN                0x00000120
#define M_DES3_KEY_GEN               0x00000131
#define M_SSF33_KEY_GEN              0x80000009

/* defined something that only used by ICK itself 
 */
#if defined( _FOR_OWN_USE_ )

void  ICK_fperror(FILE *fp, int code);
void  ICK_perror(int code);  

/* to support multi-thread way, yanghx added 2002.8.30  
 */
//commented 2002.11 for all manufacturer implemented the mutex in pkcs#11 library itself
//int	createMutex ( void **ppMutex );
//int destroyMutex( void  *pMutex  );
//int lockMutex	( void  *pMutex  );
//int unlockMutex ( void  *pMutex  );

//typedef CK_RV (* GetP11FunctionList)(CK_FUNCTION_LIST_PTR_PTR ppFunctionList);

#endif

#ifdef __cplusplus
}
#endif

#endif /* end _ICK_H_ */
