/* Filename:	Types.h
   Description: all data types used in ICK
   Author:		yanghx (yanghx@infosec.com.cn)
   Copyright:	Copyright(C) 1998-2002  Infosec Century Inc.
				All Rights Reserved.
   History:		Created by yanghx ( yanghx < yanghx@infosc.com.cn>)
				modified by yanghx 2002.4
				modified by yanghx 2002.5
*/

#ifndef __ATYPES_H__
#define __ATYPES_H__ 1

#ifdef __cplusplus
extern "C" {
#endif

/* Token flags (see B_KEY_ATTRIBUTES)
 */
#define TF_RESIDE_ON_TOKEN    0x0001
#define TF_PRIVATE            0x0002

/* KEY USAGE flags: used by both Crypto-C and Cert-C
 */
#define CF_DIGITAL_SIGNATURE  0x0100
#define CF_NON_REPUDIATION    0x0080
#define CF_KEY_ENCIPHERMENT   0x0040
#define CF_DATA_ENCIPHERMENT  0x0020
#define CF_KEY_AGREEMENT      0x0010
#define CF_KEY_CERT_SIGN      0x0008 
#define CF_CRL_SIGN           0x0004
#define CF_ENCIPHER_ONLY      0x0002
#define CF_DECIPHER_ONLY      0x0001

#define  RSA_REGISTER_SIZE	32

/* UINT4 defines a four byte word */
#if !defined (RSA_REGISTER_SIZE)
 #error Error,Please define RSA_REGISTER_SIZE
#else 
 #if RSA_REGISTER_SIZE == 16 || RSA_REGISTER_SIZE == 32
	typedef int	      			BOOL;
	typedef unsigned char  	    BYTE;
	typedef long int            LONG;           /* Variable size */
	typedef unsigned long int   ULONG;          /* Variable size */
	typedef short int           INT2;           /* 2 Octets */
	typedef unsigned short int  UINT2;
	typedef long int            INT4;           /* 4 Octets */
	typedef unsigned long int   UINT4;
 #else
	#if RSA_REGISTER_SIZE == 64
		typedef int					BOOL;
		typedef unsigned char	    BYTE;
		typedef long int            LONG;       /* Variable size */
		typedef unsigned long  int  ULONG;      /* Variable size */
		typedef short int			INT2;       /* 2 Octets */
		typedef unsigned short int  UINT2;      /* 2 Octets */
		typedef int					INT4;
		typedef unsigned int        UINT4;		/* 4 Octets */
	#endif
 #endif
#endif
		
/* POINTER defines a generic pointer type */
typedef unsigned char*			POINTER;

/*****************************************************************************/
/*                   all structures are defined below                        */
/*****************************************************************************/
typedef struct {
  BYTE	*data;
  UINT4 len;
} ITEM;

typedef struct {
  UINT4 ( *Surrender) (POINTER);
  POINTER handle;
  POINTER reserved;
} A_SURRENDER_CTX;

typedef struct {
  BYTE *key;                              /* 8-byte DES key */
  BYTE *inputWhitener;                    /* 8-byte input whitener */
  BYTE *outputWhitener;                   /* 8-byte output whitener */
} A_DESX_KEY;

/* RSA public/private key struct */    
typedef struct {
  ITEM	n;
  ITEM	ke;
} RSA_PUBLIC_KEY;

typedef struct {
  ITEM	n;
  ITEM	ke;
  ITEM	kd;
  ITEM	p;
  ITEM	q;  
  ITEM	kdp;
  ITEM	kdq;
  ITEM	A;    /* CRT coefficient */
} RSA_PRIVATE_KEY;

typedef struct {
  UINT4 effectiveKeyBits;
  BYTE  *iv;
} A_RC2_CBC_PARAMS;

typedef struct {
  //UINT4 version;
  UINT4 rounds;
  UINT4 wordSizeInBits;
  BYTE *iv;
  UINT4 ivLen;
} A_RC5_CBC_PARAMS;

typedef struct {
  UINT4 rounds;
  BYTE *iv;
} A_RC6_CBC_PARAMS;

typedef struct {
  UINT4 modulusBits;
  ITEM	publicExponent;
} A_RSA_KEY_GEN_PARAMS;

typedef struct {
  A_RSA_KEY_GEN_PARAMS keySpecs;
  UINT4 publicKeyUsage;
  UINT4 privateKeyUsage;  
  UINT4 publicLifeTime;
  UINT4 privateLifeTime;
  UINT4 protectFlag;
} A_TOKEN_RSA_KEY_GEN_PARAMS;

typedef struct {
  UINT4 encryptionBlockLen;
} A_PKCS_PARAMS;

typedef struct {
  //unsigned int keyUsage;
  UINT4 keyLengthInBytes;
  //UINT4 lifeTime;
  //unsigned int protectFlag;
  //unsigned char *cipherName;
  UINT4 mechanism;
} A_SYMMETRIC_KEY_SPECIFIER;

typedef struct {
  UINT4 keyUsage;
  UINT4 keyLengthInBytes;
  UINT4 lifeTime;
  UINT4 protectFlag;
} A_SYMMETRIC_KEY_DEFINER;

typedef struct {
  UINT4 keyUsage;
  UINT4 lifeTime;
  UINT4 protectFlag;
} A_KEYPAIR_DEFINER;

typedef struct {
  A_KEYPAIR_DEFINER privateKeyDef;
  A_KEYPAIR_DEFINER publicKeyDef;  
  POINTER keyParams;
  BYTE	 *cipherName;
} A_KEYPAIR_SPECIFIER;

/********************************************************************/

typedef int ( *B_INFO_TYPE) (POINTER *);

/* Information for password-based encryption (PBE) algorithms.
 */
typedef struct {
  BYTE	 *salt;                                        /* salt value */
  UINT4 iterationCount;                           /* iteration count */
} B_PBE_PARAMS;

typedef struct {
  UINT4		effectiveKeyBits;                     /* effective key length */
  BYTE		*salt;                                        /* salt value */
  UINT4		iterationCount;                           /* iteration count */
} B_RC2_PBE_PARAMS;

typedef struct {
  B_INFO_TYPE	cryptInfoType;
  ITEM			*cryptParams;
  B_INFO_TYPE	formatInfoType;
  ITEM			*formatParams;
} B_SEAL_OPEN_PARAMS;

/* Information used to specify signing or verifying */
typedef struct {
  BYTE		*encryptionMethodName;
  POINTER	encryptionParams;			/* Most likely to be null */
  BYTE		*digestMethodName;
  POINTER	digestParams;		 		/* Most likely to be null */
  BYTE		*formatMethodName;
  POINTER	formatParams;			
} B_SIGN_VERIFY_PARAMS;

/* Info used to specify key pair tokens at generation time */
typedef struct {
  POINTER keyParameters;
  UINT4 privateKeyUsage;
  UINT4 publicKeyUsage;
  UINT4 protectFlag;
  UINT4 publicLifeTime;
  UINT4 privateLifeTime;	
} B_TOKEN_KEYPAIR_GEN_INFO;

typedef struct {
  UINT4 tokenFlag;
  UINT4 keyUsage;
  UINT4 start;
  UINT4 end;
} B_KEY_ATTRIBUTES;

typedef struct {
  //B_KEY_ATTRIBUTES privateKeyAttributes;   /* to be used late */
  //B_KEY_ATTRIBUTES publicKeyAttributes;	 /* to be used late */
  UINT4	modulusBits;
} B_KEYPAIR_GEN_PARAMS;

/* Information for MAC algorithm.
 */
typedef struct {
  UINT4 macLen;                               /* length of MAC value */
} B_MAC_PARAMS;

/* Information for RC4 with MAC algorithm.
 */
typedef struct {
  ITEM  salt;                                         /* variable-length salt */
  UINT4 macLen;                        /* length to use for MAC value */
} B_RC4_WITH_MAC_PARAMS;

/* Information for PKCS V2 OAEP Algorithm
*/
typedef struct 
{
char*			hashFunc;   /* ժҪ:ASCII string. SHA1 for NULL*/
ITEM 			hashFuncParams;
char* 			maskGenFunc; /*ASCII string. MGF1 for NULL */
ITEM 			maskGenFuncParams;
char* 			maskGenFuncUnderlyingAlg;/* maskGenFuncUnderlyingAlg:ASCII string.SHA1 for NULL*/
ITEM 			maskGenFuncUnderlyingAlgParams;

/* pSourceFunc is the method for determining the parameters, P.  
   pSourceFunc may contain a NULL_PTR or a pointer to the 
   null-terminated ASCII string, "specified parameters".  
   In  both cases "specified parameters" will become the 
   pSource method.  

If pSourceFunc is "specified parameters" then pSourceParams 
may be specified in two ways:

1. As a NULL_PTR.  		P is then assumed to be empty. 
2. As an ITEM 			ITEM contains the specified value for P.
*/
char* 			pSourceFunc; 
ITEM			pSourceParams;
} A_PKCS_OAEP_PARAMS;

typedef struct {
  char year[4];
  char month[2];
  char day[2];
} B_DATE;

/* Information to set up a chooser for use with a PKCS #11 device
 * when the caller wants to use a pre-established session.
 */
typedef struct {
	ULONG			sessionHandle;			/* in PKCS 11, a session handle is a CK_SESSION_HANDLE, which is an unsigned long int */
	POINTER			pP11FunctionList;       /* A Cryptoki C_FunctionListPtr */
	char			*libraryName;			/* The name of the shared library (DLL, .so, etc.) */
	ITEM			tokenLabel;				/* user-defined label to different tokens */
	ITEM			passPhrase;				/* Possibly needed to login into the device */ 
} B_PKCS11_SESSION;

typedef struct _PKCS11_FingerPrint{
	char			*libraryName;			/* The name of the shared library (DLL, .so, etc.) */
	ITEM			tokenLabel;				/* user-defined label to different tokens */
	ITEM			passPhrase;				/* Possibly needed to login into the device */ 
}PKCS11_PARA;

#ifdef __cplusplus
}
#endif

#endif /* _TYPES_H_ */

