/*
 CEA encryption algorithm extention implementation. 
 This extention uses Xu JianZhuo's newest implementation of CEA algorithm.
 It is a platform-independent implementation using ANSI C.

 CEAextention is programmed by Zuo Yingnan [ynzuo@hotmail.com]
 1998/11/22
*/

#ifndef _CEA_EXT_H_
#define _CEA_EXT_H_

#include "cea.h"

#ifdef __cplusplus
extern "C"{
#endif

/****************************/
int CEA_encrypt(unsigned char * in, unsigned char * out,unsigned long in_len,char * key, int key_len);

/*
 Description:
	This function used to encrypt plaintext(in) to ciphertext(out).
	It supports cipher-steal mode usage of the block encryption
	algorithm. When the in_len is not the mutipule of 16 bytes, it
	can use cipher-steal technology to ensure that the length of
	ciphertext(out) is equal to in_len.
 Parameters:
	in	The plaintext data.
	out	The ciphertext data.
	in_len	The length of plaintext and ciphertext. We support maximum
		length is 2^32
	key_len	The length of key.
 Returns:
	CEA_ERR_MPI_BYTE: The length of mpi is error defined					
	CEA_SUCCESS:	  Operation successfully done.
	
*/

/***************************/	
int CEA_decrypt(unsigned char * in, unsigned char * out, unsigned long in_len,char * key, int key_len);
/*
 Description:
	This function used to decrypt ciphertext(in) to plaintext(out).
	The length of plaintext(out) is equal to in_len.
 Parameters:
	in	The ciphertext data.
	out	The plaintext data.
	in_len	The length of cipherext and plaintext. We support maximum
		length is 2^32
	key_len	The length of key.
 Returns:
	CEA_ERR_MPI_BYTE: The length of mpi is error defined					
	CEA_SUCCESS:	  Operation successfully done.
*/


#ifdef __cplusplus
}
#endif

#endif /* _CEA_EXT_H_ */
