<?php
/**
 * User: liuyuzhen
 * Date: 2018/5/29
 * Time: 16:22
 * Description:
 */

class HomeController extends \Our\Controller_AbstractIndex{

    public function indexAction(){
        $returnData = array();
        //获取首页广告位
        $advs = $this->getAdvsAction(true);
        if($advs){
            $returnData['advs'] = $advs;
        }

        //获取地址相关信息
        $currentAddress = $this->setAddressAction(true);
        if(!isset($currentAddress['addresses'])){
            $currentAddress['addresses'] = array();
        }
        $returnData['currentAddress'] = $currentAddress;

        $currentAddress = $this->sess->get('currentAddress');

        //获取首页推荐分类
        $resultClasses = $this->getPlatformGoodsClassAction(true);
        if($resultClasses){
            $returnData['recommendClasses'] = $resultClasses;
        }

        //获取当前位置对应附近店铺

        $nearbyStores = $this->getNearbyStoresAction(true);
        $returnData['nearbyStores'] = $nearbyStores;

        //获取附近店铺对应的商品
        $recommendGoods = $this->getIndexHotSalesGoodsAction(true);

        $returnData['recommendGoods'] = $recommendGoods;

        $shareInfo = \Business\Common\CommonServiceModel::getInstance()->getShareInfo(\Our\ApiConst::sharePlat);
        $returnData['shareInfo'] = $shareInfo;
        $this->success($returnData);
    }

    /**
     * 设置当前地址
     * @param bool $flag
     * @return mixed
     */
    public function setAddressAction($flag = false){
        $data = $this->req[\Our\NameConst::data];
        $addressService = \Business\User\AddressServiceModel::getInstance();
        $memberId=$this->sess->get('member_id');
        $currentAddress =$addressService->setAddress($data,$memberId);
        if($flag){
            return $currentAddress;
        }
        $this->success($currentAddress);
    }

    /**
     * 设置首页热销商品
     * @param bool $flag
     * @return array
     */
    public function getIndexHotSalesGoodsAction($flag = false){
        $currentAddress = $this->sess->get('currentAddress');
        $goodsCommonService = \Business\Goods\GoodsCommonServiceModel::getInstance();
        $recommendGoods = $goodsCommonService->getIndexHotSalesGoods($currentAddress);
        if($flag){
            return $recommendGoods;
        }
        $this->success($recommendGoods);
    }

    /**
     * 设置首页附近店铺
     * @param bool $flag
     * @return array
     */
    public function getNearbyStoresAction($flag = false){
        $currentAddress = $this->sess->get('currentAddress');
        $storesService = \Business\Store\StoreServiceModel::getInstance();
        $nearbyStores = $storesService->getNearbyStores($currentAddress);
        if($flag){
            return $nearbyStores;
        }
        $this->success($nearbyStores);
    }


    /**
     * 设置首页推荐分类
     * @param bool $flag
     * @return array
     */
    public function getPlatformGoodsClassAction($flag = false){
        $currentAddress = $this->sess->get('currentAddress');
        $goodsClassService = \Business\Goods\GoodsClassServiceModel::getInstance();
        $resultClasses = $goodsClassService->getHomeIndexGoodsClasses($currentAddress);
        if($flag){
            return $resultClasses;
        }
        $this->success($resultClasses);
    }

    /**
     * 获取首页广告
     * @param bool $flag
     * @return array
     */
    public function getAdvsAction($flag=false){
        //获取广告位内容
        $advService = \Business\Common\AdvServiceModel::getInstance();
        $advs= $advService->getHomeAdv();
        if($flag){
            return $advs;
        }
        $this->success($advs);
    }

    public function getAllClassesAction(){
        $data = $this->req[\Our\NameConst::data];
        $currentAddress = $this->sess->get('currentAddress');
        if(!$currentAddress){
            $currentAddress = $data;
        }
        $goodsClassService = \Business\Goods\GoodsClassServiceModel::getInstance();
        $parentGoodsClasses = $goodsClassService->getPlatformGoodsClass($currentAddress);
        //获取广告位内容
        $advService = \Business\Common\AdvServiceModel::getInstance();
        $advs= $advService->getHomeClassAdvs();

        $returnData['advs'] = $advs;
        $returnData['recommendClasses'] = $parentGoodsClasses;


        $this->success($returnData);
    }

    /**
     * 换一批店铺
     */
    public function getOtherStoresAction(){
        $data = $this->req[\Our\NameConst::data];
        $currentAddress = $this->sess->get('currentAddress');
        if(!$currentAddress){
            $currentAddress = $data;
        }
        $storesService = \Business\Store\StoreServiceModel::getInstance();
        $ohterStore = $storesService->getOtherNearbyStores($currentAddress);
        $this->success($ohterStore);
    }

    /**
     * 获取其他热销商品
     */
    public function getOtherGoodsAction(){
        $data = $this->req[\Our\NameConst::data];
        $currentAddress = $this->sess->get('currentAddress');
        if(!$currentAddress){
            $currentAddress = $data;
        }
        $goodsCommonService = \Business\Goods\GoodsCommonServiceModel::getInstance();
        $otherGoods = $goodsCommonService->getIndexHotSalesGoods($currentAddress);
        $this->success($otherGoods);
    }
}