<?php
/**
 * Created by PhpStorm.
 * User: liuyu
 * Date: 2018/9/1
 * Time: 20:06
 */

define("APPLICATION_PATH", realpath(dirname(__FILE__) . '/../../../')); //指向public的上一级
require APPLICATION_PATH . '/scripts/crontab/baseCli.php';
require APPLICATION_PATH . '/scripts/crontab/common.php';
error_reporting(E_ALL ^ E_NOTICE);
class cliStoreTopSaleGoods extends basecli
{
    const CLI_ADMIN_ID = 255;
    private $bDoUnLock  = FALSE;   // 是否允许释放 LOCK 文件
    private $_debug = 0;
    private $lockFileName;
    private $fromState;
    private function mkdirs($dir, $mode = 0777)
    {
        if (is_dir($dir) || @mkdir($dir, $mode)){
            return TRUE;
        }
        if (!$this->mkdirs(dirname($dir), $mode)){
            return FALSE;
        }
        return @mkdir($dir, $mode);
    }
    /**
     * 析构
     */
    public function __destruct()
    {
        parent::__destruct();
        if ($this->bDoUnLock)
        {
            @unlink($this->lockFileName);

        }
    }
    protected function updateStoreTopSaleGoods(){
        \Business\Goods\GoodsCommonServiceModel::getInstance()->updateStoreTopSaleGoods();
    }
    protected function _runCli()
    {

        $this->_debug = isset($this->aArgv[1]) ? intval($this->aArgv[1]) : 0;
        if ($this->_debug)
        {
            echo "*** Debug mode ***\n";
        }
        // Step: 02 检查是否已有相同CLI在运行中
        $lockDir=$this->_getBaseFileName('StoreTopSaleGoods');
        if(!$this->mkdirs($lockDir)){
            echo '****create dir fail  ****';
            exit;
        }
        $this->lockFileName = $lockDir .'.locks';
        if( file_exists( $this->lockFileName ) )
        {
            $stat = stat($this->lockFileName);
            if( (TIMESTAMP - $stat['mtime']) > 24*60*60*2 )
            {
                echo "文件被锁超过2天，被强制删除";
                @unlink($this->lockFileName);
            }
            else
            {
                $this->halt( '[' . date('Y-m-d H:i:s') .'] The CLI is running'."\n");
            }
        }
        $this->bDoUnLock = true;
        file_put_contents($this->lockFileName ,"running" ); // CLI 独占锁
        $this->updateStoreTopSaleGoods();

        echo '首页热销商品更新成功'."\r\n";
    }
}

$oCli = new cliStoreTopSaleGoods(TRUE);

EXIT;
?>