<?php

namespace DAO;
/**
 * 卖家操作日志
 * Class SellerLogModel
 * @package DAO
 */
class SellerLogModel extends \DAO\AbstractModel {


    private $logField = 'log_content as logContent , log_time as logTime';
    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_seller_log';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'log_id';
    public function init(){

    }

    public function insert($param){
        $param['log_time'] =TIMESTAMP;
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        return $this->db->insert($this->_tableName)->rows($param)->execute();
    }

    /**
     * 记录操作日志
     * @param $content
     * @param int $state
     * @param array $seller
     * @return mixed
     */
    public function record($content, $seller = array(), $state = 1){
        $seller_info = array();
        $seller_info['log_content'] = $content;
        $seller_info['log_time'] = TIMESTAMP;
        $seller_info['log_seller_id'] = $seller['seller_id'];
        $seller_info['log_seller_name'] = $seller['seller_name'];
        $seller_info['log_store_id'] = $seller['store_id'];
        $seller_info['log_seller_ip'] = $_SERVER['REMOTE_ADDR'];
        $seller_info['log_url'] = $_SERVER['REQUEST_URI'];
        $seller_info['log_state'] = $state;
        return $this->insert($seller_info);
    }

    public function getList($where){
        $this->setDb($this->dbName);
        if(is_array($where)){
            $where=$this->db->getSqlWhereByArray($where);
        }
        $result = $this->db->select($this->logField)->from($this->_tableName)->where($where)->fetchAll();
        return $result;
    }


    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance($dbName=\Our\DbNameConst::salveDBConnectName) {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }

}
