<?php

namespace DAO\Store;


class StoreJoininModel extends \DAO\AbstractModel
{


    

    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_store_joinin';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'member_id';

    public function init()
    {
    }


    public function getOne($where,$field)
    {
        $this->setDb();
        $data = $this->db->select($field)->from($this->_tableName)->where($where)->fetchOne();
        return $data;
    }

    public function getOneByMemberId($memberId,$field) {
        $where['member_id'] = $memberId;
        return $this->getOne($where,$field);
    }

    public function getOneByMemberIdCache($memberId,$field) {
        return \Our\RedisHelper::cachedFunction(\Redis\Db6\StoreRedisModel::getInstance(),array(&$this, 'getOneByMemberId'),array($memberId,$field),\Our\ApiConst::oneDaySecond,array($memberId));
    }


    public function save($data, $where){
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        $result = $this->db->update($this->_tableName)->rows($data)->where($where)->execute();
        return $result;
    }

    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance()
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }


}
