<?php
namespace Goods;
/**
 * 获取商品相关工具类
 * User: liuyuzhen
 * Date: 2018/7/16
 * Time: 16:11
 * Description:
 */

class GoodsUtil {

    /**
     * 获取商品价格统一接口
     * @param $goodsId
     * @param null $memberId
     * @param null $activities
     * @return mixed
     * @throws \Our\Exception
     */
    public function getRealPrice($goodsId,$memberId = null,$activities = null,$type = \Our\ApiConst::addGoodsToCart,$dbName = \Our\DbNameConst::salveDBConnectName,$array = false){
        if($type == \Our\ApiConst::addGoodsToCart){
            $goodsDao = \DAO\GoodsModel::getInstance($dbName);
            $goods = \Our\RedisHelper::cachedFunction(\Redis\Db4\GoodsRedisModel::getInstance(),array(&$goodsDao, 'find'),array(array('goods_id'=>$goodsId),'*'),\Our\ApiConst::oneHour,array($goodsId));
            $storeId = $goods['store_id'];
            //该用户是否有参加这个店铺销售活动
            if($activities === null){
                $activities = \DAO\SaleMemberModel::getInstance()->isJoinStore($storeId,$memberId);
            }
            if($activities){
                if($data = \DAO\SaleGoodsModel::getInstance()->getSaleGoods($storeId,$goodsId)){
                    $price = \DAO\SaleGoodsModel::getInstance()->getSalePrice($data,$activities,$array);
                    return $price ? $price : $goods['goods_price'];
                }
            }
            return $goods['goods_price'];
        }else{
            $pBundlingService = \Business\Goods\GroupSaleServiceModel::getInstance();
            $pBundling = $pBundlingService->getOnePBundingCache($goodsId,$dbName);
            return isset($pBundling['discountPrice'])?$pBundling['discountPrice']:\Our\ApiConst::zero;
        }
    }

    /**
     * 类实例
     *
     */
    private static $_instance = null;

    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance()
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }
}