<?php
namespace DAO\Order;

/**
 * 订单支付表
 * User: liuyuzhen
 * Date: 2018/7/2
 * Time: 11:20
 * Description:
 */
class OrderPayModel extends \DAO\AbstractModel{

    protected $_tableName = 'han_order_pay';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'pay_id';

    public function init(){
    }

    /**
     * 更新数据
     * @param $data
     * @param $where
     * @return mixed
     */
    public function update($data,$where)
    {
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        return $this->db->update($this->_tableName)->where($where)->rows($data)->execute();
    }

    public function insert($data){
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        $result = $this->db->insert($this->_tableName)->rows($data)->execute();
        return $result ;
    }

    /**
     * 获取单条数据
     * @param $where
     * @return array
     */
    public function find($where,$field = \Our\NameConst::allField)
    {
        $this->setDb($this->dbName);
        $data = $this->db->from($this->_tableName)->select($field)->where($where)->fetchOne();
        return $data;
    }

    public function findById($id)
    {
        $where[$this->_primaryKey] = $id;
        return $this->find($where);
    }


    public function getOrderPayStatus($paySn){
        $orderPayRedis = \Redis\Db5\OrderPayRedisModel::getInstance();
        $orderPay = $orderPayRedis->find($paySn);
        if(!$orderPay){
            $orderPay = $this->find(array('pay_sn'=>$paySn));
            if($orderPay){
                $orderPayRedis->update($paySn,$orderPay,\Our\ApiConst::oneHour);
            }
        }
        return $orderPay;
    }

    /**
     * 类实例
     */
    private static $_instance = null;

    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance($dbName = \Our\DbNameConst::salveDBConnectName)
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }

}