/*
Module:  CEA Algrithm
Discription:
		The block size of CEA is define by CEA_BLOCK_SIZE
Author:
		Xu JianZhuo(xjz@hotmail.com)
LastModify:
		1998/11/1
*/
#ifndef CEA_H
#define CEA_H
#define CEA_BLOCK_SIZE 128
/*
The length of block (Bit)
The length should be 64,128,256
*/
#define  CEA_MPI_BIT (CEA_BLOCK_SIZE/2)
/*
	1:The bit count of each MPI
	2:The block size of the data to encrypt MUST be 2*CEA_BLOCK_BIT
	3:It can be 16,32,64 or 128
*/
#define  CEA_ROTATE 6
/*The rotate to calculate*/
#define  CEA_MPI_BYTE (CEA_MPI_BIT/8)
/*The MPI lenth used in algrithm*/

#define CEA_ENCRYPT  0
#define CEA_DECRYPT  1
typedef struct _CEA_STATUS{
	unsigned char ExtendKey[2*CEA_ROTATE+4][CEA_MPI_BYTE];
}CEA_STATUS,*PCEA_STATUS;

typedef enum _CEA_RET{
	CEA_SUCCESS, 		/*Ok*/
	CEA_ERR_MPI_BYTE,   /*MPI Byte number define error*/
	CEA_ERR_INIT,       /*Init Status error*/
	CEA_ERR_WORKMODE,   /*WorkMode should be CEA_ENCRYPT or CEA_DECRYPT*/
	CEA_ERR_TOOSHORT	/* input length is less than CEA_BLOCK_SIZE */
}CEA_RET;

#ifdef __cplusplus
extern "C"{
#endif

extern CEA_RET CEAInitStatus(PCEA_STATUS Status,unsigned char * Key,int KeyLenth);
/*
Discription:
	It expand the key to status
Argument:
	Status:		Store the expanded key here
	Key:		The key to encrypt
	KeyLenth:   The lenth of the key (BYTE),
				0<KeyLenth<=(2*Rotate+4)*CEA_MPI_BYTE
Return:
	CEA_ERR_MPI_BYTE:		The length of mpi is error defined					
	CEA_SUCCESS:			Initiate OK
*/
extern void CEAEncrypt(unsigned char * Plaintext,unsigned char *Ciphertext,PCEA_STATUS Status);
/*
Discription:
	1:It encrypt the source string and output to target.
	2:The Souce string can over lap with target string
	3:The lenth of the Plaintxt and Ciphertext is CEA_BLOCK_SIZE bits
Argument:
	Plaintext:	 The Plaintext
	Ciphertext:	 The Ciphertext
	Status:	     The Expanded key
*/
extern void CEADecrypt(unsigned char *Ciphertext,unsigned char *Plaintext,PCEA_STATUS Status);
/*
Discription:
	1:It decrypt the cipher string.
	2:The Souce string can over lap with target string
	3:The lenth of the Plaintxt and Ciphertext is CEA_BLOCK_SIZE bits
Argument:
	Plaintext:	 The Plaintext
	Ciphertext:	 The Ciphertext
	Status:	     The Expanded key

*/
extern CEA_RET CEACoder(unsigned char  *Source,unsigned char *Target,unsigned char *Key,unsigned int KeyLenth,unsigned int WorkMode);
/*
Discription:
	It encrypt or decrypt the source sting to target string
Argument:
	Source:		Plaintext while encrypt and Ciphertext while decrypt
	Target:     Ciphertext while encrypt and Plaintext while decrypt
	Key:		Key
	WorkMode:	It must be CEA_ENCRYPT or CEA_DECRYPT
Return:
	CEA_ERR_INIT:		Initiate key error
	CEA_ERR_WORKMODE:	The workmode should be CEA_ENCYPT or  CEA_DECRYPT
	CEA_SUCCESS:		Encrypt/decrypt right  
*/



#ifdef __cplusplus
}
#endif

#endif
