<?php
define("APPLICATION_PATH", realpath(dirname(__FILE__) . '/../../../')); //指向public的上一级
require APPLICATION_PATH . '/scripts/crontab/baseCli.php';
require APPLICATION_PATH . '/scripts/crontab/common.php';
error_reporting(E_ALL ^ E_NOTICE);
class bridgeStart
{
    /* config */
    const LISTEN = "tcp://192.168.2.15:5555";
    const MAXCONN = 100;
    const pidfile = __CLASS__;
    const uid = 81;
    const gid = 81;
    /**/
    protected $pool = NULL;
    protected $zmq = NULL;

    public function __construct()
    {
        $this->pidfile = '/var/run/' . self::pidfile . '.pid';
    }

    private function daemon()
    {
        if (file_exists($this->pidfile)) {
            echo "The file $this->pidfile exists.\n";
            exit();
        }

        $pid = pcntl_fork();
        if ($pid == -1) {
            die('could not fork');
        } else if ($pid) {
// we are the parent
//pcntl_wait($status); //Protect against Zombie children
            exit($pid);
        } else {
// we are the child
            file_put_contents($this->pidfile, getmypid());
            posix_setuid(self::uid);
            posix_setgid(self::gid);
            return (getmypid());
        }
    }
    public function callback($instance,$channelName,$message){
        $orderService=\Business\Order\OrderServiceModel::getInstance();
        $orderService->testPush($message);
    }
    protected function status(){
        if (file_exists($this->pidfile)) {
            $pid = file_get_contents($this->pidfile);
            printf("%s already running, pid = %s\n", $this->argv[0], $pid);
        }else{
            printf("%s haven't running\n", $this->argv[0]);
        }
    }
    private function start()
    {
        $pid = $this->daemon();
        $conf = \Yaf\Registry::get('config')->get('redis.database.params');
        $http = new swoole_http_server("0.0.0.0", 9501);
        $http->on('request', function ($request, $response) {
            try{
                $respData=$request->post;
                // echo json_encode($respData);

                if(isset($respData['type'])&&$respData['type']==1){
                    $info=$respData['content'];
                    $memberDao=$info['className']::getInstance(\Our\DbNameConst::masterDBConnectName);
                    echo json_encode($info);
                    if(empty($info['params'])){
                        $res=call_user_func_array(array($memberDao,$info['method']),array());
                    }else{
                        $res=call_user_func_array(array($memberDao,$info['method']),$info['params']);
                    }
                    $res=(isset($res)&&!empty($res))?$res:false;
                    unset($memberDao);
                    \Mysql\LinkMySQLModel::unsetDbConecet();
                    if($res!==false){
                        echo 'success';
                        $response->end(json_encode(array('status'=>1,'message'=>'执行成功','data'=>$res)));
                    }else{
                        echo 'fail1';
                        $response->end(json_encode(array('status'=>0,'message'=>'执行失败')));
                    }
                }else{
                    echo 'fail2';
                    $response->end(json_encode(array('status'=>0,'message'=>'执行失败')));
                }
            }catch(Exception $ex){
                throw new Exception($ex->getMessage(),$ex->getCode());
            }
        });
        $http->start();

    }
    private function reload(){
        if (file_exists($this->pidfile)) {
            $pid = file_get_contents($this->pidfile);
            //posix_kill(posix_getpid(), SIGHUP);
            posix_kill($pid, SIGHUP);
        }
    }
    protected function restart(){
        $this->stop();
		sleep(1);
        $this->start();
    }

    private function stop()
    {

        if (file_exists($this->pidfile)) {
            $pid = file_get_contents($this->pidfile);
            posix_kill($pid, 9);
            unlink($this->pidfile);
        }
    }

    private function help($proc)
    {
        printf("%s start | stop | help | restart | reload \n", $proc);
    }
    private $argv;
    public function main($argv)
    {
        $this->argv=$argv;
        if (count($argv) < 2) {
            printf("please input help parameter\n");
            exit();
        }
        if ($argv[1] === 'stop') {

            $this->stop();
        } else if ($argv[1] === 'start') {
            $this->start();
        } else if($argv[1] === 'restart'){
            $this->restart();
        }else if($argv[1] === 'status'){
            $this->status();
        }else if($argv[1]==='reload'){
            $this->reload();
        }
        else{
            $this->help($argv[0]);
        }
    }
}

$cgse = new bridgeStart();
$cgse->main($argv);