<?php
/**
 * 公共工具
 * User: liuyuzhen
 * Date: 2018/6/14
 * Time: 13:38
 * Description:
 */

class CommonController extends \Our\Controller_AbstractIndex{


    /**
     * 删除用户(仅用于测试和开发环境)
     * @throws Exception
     * @throws \Error\OurExceptionModel
     */
    public function delMemberAction(){
        $data = $this->req[\Our\NameConst::data];
        $commonServiceModel = \Business\Common\CommonServiceModel::getInstance();
        $result = $commonServiceModel->delMember($data);
        if($result){
            $this->success(new stdClass(),\Our\DescribeConst::delMemberSuccess,\Our\DescribeConst::delMemberSuccess);
        }
        \Error\ErrorModel::throwException(\Error\CodeConfigModel::deleteMemberFailed);
    }


    /**
     * 设置当前经纬度地址
     */
    public function setCurrentAddressAction(){
        $data = $this->req[\Our\NameConst::data];
        $data['choosedFlag'] = \Our\ApiConst::one;
        $addressService = \Business\User\AddressServiceModel::getInstance();
        $memberId = $this->sess->get('member_id');
        $result = $addressService->setAddress($data,$memberId);
        if($result){
            $this->success(new stdClass() ,\Our\DescribeConst::setAddressSuccess,\Our\DescribeConst::setAddressSuccess);
        }
        \Error\ErrorModel::throwException(\Error\CodeConfigModel::setAddressFailed);
    }


    /**
     * 获取我的收货地址
     */
    public function getMyAddressesAction(){

        $addressService = \Business\User\AddressServiceModel::getInstance();

        $memberId = $this->sess->get('member_id');
        $addresses = $addressService->getMyAddresses($memberId);
        if($addresses){
            $this->success($addresses);
        }
        $this->success(array(),\Our\DescribeConst::emptyMyAddresses,\Our\DescribeConst::emptyMyAddresses);
    }

}