<?php

namespace Our;
use Business\User\MemberServiceModel;
use Error\CodeConfigModel;
use Error\ErrorModel;
/**
 * api模块控制器抽象类
 *
 * @package Our
 * @author iceup <sjlinyu@qq.com>
 */
abstract class Controller_AbstractClient extends \Our\Controller_Abstract {

    public $config;
    public $redis;
    public $key;
    public $req;
    public $memberId;
    public $storeId;
    public $sellerName;
    public $sellerId;
    public $memberName;
    /**
     * api控制器直接输出json格式数据，不需要渲染视图
     */
    public function init() {
        $this->req=$this->getRequest()->getPost();
        $this->checkEncrypt();
        if(empty($this->req['data']['key'])){
            ErrorModel::throwException(CodeConfigModel::illegalAccess);
        }
        session_id($this->req['data']['key']);
        //  ini_set('session.gc_maxlifetime', ApiConst::tenDaySecond);
        $sess=\Yaf\Session::getInstance();
        $sess->start();
        $this->memberId=$sess->get('member_id');
        $this->memberName=$sess->get('member_name');
        $this->storeId=$sess->get('store_id');
        $this->sellerName=$sess->get('seller_name');
        $this->sellerId=$sess->get('seller_id');
        if(empty($this->memberId)){
            ErrorModel::throwException(CodeConfigModel::noLogin);
        }
        if(isset($sess['other_login']) && $sess['other_login']==ApiConst::one){
            $memberService=MemberServiceModel::getInstance();
            $memberService->clearKey($this->req['data']['key']);
            ErrorModel::throwException(CodeConfigModel::otherDriverLogin);
        }
        \Yaf\Dispatcher::getInstance()->disableView();
    }
    public function getAuthKey(){
        $this->key=Common::bulidToken();
        $this->redis->hset($this->key,NameConst::sessionKey,$this->key,ApiConst::tenMin);
    }


    public function loginCheck(){

    }

}
