<?php
namespace Store;
/**
 * User: liuyuzhen
 * Date: 2018/10/18
 * Time: 17:34
 * Description:
 */

class StoreUtil {

    public function checkAddressInServiceAreaByStore($address,$store){
        $storeDao = \DAO\StoreModel::getInstance();
        //$store = $storeDao->get($storeId,false);
        $storeId = $store['store_id'];
        $inAreaFlag = false ;
        $qmStoreClassDao = \DAO\QmStoreClassModel::getInstance();
        $qmClassCon['store_id'] = $storeId;
        $qmSignScopeList = \Our\RedisHelper::cachedFunction(\Redis\Db6\QmStoreClassRedisModel::getInstance(),array(&$qmStoreClassDao, 'getStoreSignClasses'),array($qmClassCon,'sign_scope'),\Our\ApiConst::oneHour,array('store'.$storeId));
        if($qmSignScopeList){
            foreach($qmSignScopeList as $qmSignScope){
                if($qmSignScope['sign_scope']){
                    $inAreaFlag = \Our\CommonExtension::locationInArea($address['lat'],$address['lng'],$qmSignScope['sign_scope']);
                    if($inAreaFlag){
                        return true;
                    }
                }
            }
        }
        if(!$store['store_sales_scope']){
            return false;
        }
        $inAreaFlag = \Our\CommonExtension::locationInArea($address['lat'],$address['lng'],$store['store_sales_scope']);
        return $inAreaFlag;
    }


    public function checkAddressInServiceArea($address,$storeId){
        $storeDao = \DAO\StoreModel::getInstance();
        $store = $storeDao->get($storeId,false);
        $inAreaFlag = false ;
        $qmStoreClassDao = \DAO\QmStoreClassModel::getInstance();
        $qmClassCon['store_id'] = $storeId;
        $qmSignScopeList = \Our\RedisHelper::cachedFunction(\Redis\Db6\QmStoreClassRedisModel::getInstance(),array(&$qmStoreClassDao, 'getStoreSignClasses'),array($qmClassCon,'sign_scope'),\Our\ApiConst::oneHour,array('store'.$storeId));
        if($qmSignScopeList){
            foreach($qmSignScopeList as $qmSignScope){
                if($qmSignScope['sign_scope']){
                    $inAreaFlag = \Our\CommonExtension::locationInArea($address['lat'],$address['lng'],$qmSignScope['sign_scope']);
                    if($inAreaFlag){
                        return true;
                    }
                }
            }
        }
        if(!$store['store_sales_scope']){
            return false;
        }
        $inAreaFlag = \Our\CommonExtension::locationInArea($address['lat'],$address['lng'],$store['store_sales_scope']);
        return $inAreaFlag;
    }

    /**
     * 经纬度是否在店铺地址范围内
     * @param $lat
     * @param $lng
     * @param $storeId
     * @return bool
     */
    public function checkLocationInServiceArea($lat,$lng,$storeId){
        return self::checkAddressInServiceArea(array('lat'=>$lat,'lng'=>$lng),$storeId);
    }

    public function calcChargeMoney($param){
        /*$storeIds = array_keys($param);
        $qmStoreClassModel = \DAO\QmStoreClassModel::getInstance();
        $list = $qmStoreClassModel->getList(array('store_id'=>array('in',$storeIds),'class_style'=>2,'is_charged'=>1,'qm_store_class.deadline'=>array('lt',$store['contract_time'])),'');//当前店铺正在经营的二级签约分类

        /*if(count($list)!=count($gcIds)){
            showMessage('存在不能续费的分类');
        }*/
        /*$gcParentIds = array_unique(array_column($list,'gc_parent_id'));
        $tempGoodsClassList = Model('goods_class')->getGoodsClassList(array('gc_id'=>array('in',$gcParentIds)),'gc_id,gc_name');
        $goodsClassList = array();
        foreach($tempGoodsClassList as $tempClass){
            $goodsClassList[$tempClass['gc_id']] =  $tempClass;
        }
        foreach($list as &$temp){
            $temp['gc_parent_name'] = $goodsClassList[$temp['gc_parent_id']]['gc_name'];
        }
        $maxDeadline = max(array_column($list,'deadline'));
        $storeEndTime = $store['store_end_time'];
        $currExpTime  = max(array($storeEndTime,$maxDeadline));
        $currentMonthEnd = mktime(0,0,0,(date('m')+1),1,date('Y'))-1;
        if($currExpTime<$currentMonthEnd){
            $startEndTime = mktime(0,0,0,(date('m')+1),1,date('Y'))-1;
        }else if($currExpTime==$currentMonthEnd){
            $startEndTime = mktime(0,0,0,(date('m')+2),1,date('Y'))-1;
        }else{
            $futureEndTime =  mktime(0,0,0,(date('m',$currExpTime)+1),1,date('Y',$currExpTime))-1;
            if($futureEndTime>$currExpTime){
                $startEndTime =  mktime(0,0,0,(date('m',$currExpTime)+1),1,date('Y',$currExpTime))-1;
            }else{
                $startEndTime = mktime(0,0,0,(date('m',$currExpTime)+2),1,date('Y',$currExpTime))-1;
            }
        }
        $startFee = 0;
        foreach($list as $class){
            $tempCurrExpTime = max(array($storeEndTime,$class['deadline']));
            $startFee += $this->getChargedMoney($class,$tempCurrExpTime,$startEndTime);
        }

        if(chksubmit()){
            try{
                $endDate = $_POST['endDate'];
                if(!$endDate){
                    throw new Exception('缴费至期限不能为空');
                }
                $dateArr = explode('-',$endDate);
                if(count($dateArr)!=2){
                    throw new Exception('截止时间格式错误');
                }
                $endTime = mktime(0,0,0,($dateArr[1]+1),1,$dateArr[0])-1;

                if($endTime<$startEndTime){
                    throw new Exception('截止时间不能小于'.date('Y-m',$startEndTime));
                }
                $currentTime = TIMESTAMP;
                $paySn = date('YmdHis').$this->createncode(18);
                $payLog = array();
                $payLog['store_id'] = $store_id;
                $payLog['pay_state'] = 0;
                $payLog['pay_sn'] = $paySn;
                $payLog['gmt_create'] = $currentTime;
                $payLog['pay_type'] = $_POST['pay_type'];
                $payContent  = array();
                $pay_amount = 0;
                foreach($list as $class){
                    $chargeLog = array();
                    $feeArr = $this->getChargedMoney($class,$storeEndTime,$endTime,false);
                    $chargeLog['gc_id'] = $class['gc_id'];
                    $chargeLog['store_id'] = $store_id;
                    $chargeLog['pay_sn'] = $paySn;
                    $chargeLog = array_merge($feeArr,$chargeLog);
                    $payContent[] = $chargeLog;
                    $pay_amount += $feeArr['service_fee'];
                }
                $payLog['pay_amount'] =$pay_amount;
                $payLog['pay_content'] = serialize($payContent);
                $result = BaseModel('store_class_pay_log')->add($payLog);
                if(!$result){
                    throw new Exception('支付记录写入失败');
                }
                if(intval($payLog['pay_type'])==1){
                    $param['body']='我的身边店-订单编号'.$paySn;
                    $param['attach']='c|'.$paySn;
                    $param['pay_sn'] =$paySn;
                    $param['pay_amount']=$pay_amount;
                    $param['store_name']=$store['store_name'];
                    $result1=Model('store_class_pay_log')->generatePayQrcode($param);
                    if(!$result1){
                        showMessage('二维码生成失败','','html','error');
                    }
                    import('function.redisHelper');
                    excuteYafMethod('\DAO\QmStoreClassModel','delStoreSignClassesCache',array($store['store_citycode']));
                    $this->ajaxReturn(array('payType'=>1,'qrcodeUrl'=>UPLOAD_SITE_URL.DS.ATTACH_SIGNCLASS.DS.$result1,'paySn'=>$paySn),'二维码生成成功','1');
                }else{
                    import('function.redisHelper');
                    excuteYafMethod('\DAO\QmStoreClassModel','delStoreSignClassesCache',array($store['store_citycode']));
                    $this->ajaxReturn(array('payType'=>2,'paySn'=>$paySn),'待支付数据生成成功','1');
                }
            }catch(Exception $e){
                $this->ajaxReturn('',$e->getMessage(),'0');
            }
        }*/
    }

    /**
     * 类实例
     *
     */
    private static $_instance = null;

    /**
     * 单例模式获取类实例
     *
     */
    public static function getInstance()
    {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }
}