<?php
namespace DAO\GoodsClass;
/**
 * User: liuyuzhen
 * Date: 2019/1/23
 * Time: 16:18
 * Description:
 */
class StoreClassChargeLogModel extends \DAO\AbstractModel{
    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_store_class_charge_log';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'id';
    public function init(){

    }

    public function getList($where,$field){
        $this->setDb();
        return $this->db->select($field)->from($this->_tableName)->where($where)->fetchAll();
    }

    /**
     * 计算分类对应
     * @param $class
     * @param $storeEndTime
     * @param int $month
     * @return array|bool
     */
    public function getFreeChargeMoney($class,$storeEndTime,$month=1){
        if($month<=0){
            return false;
        }
        $currentTime = mktime(23,59,59,date('m'),date('d'),date('Y'));
        $tempOldTime  = max(array($storeEndTime,$class['deadline']));
        $oldTime = mktime(23,59,59,date('m',$tempOldTime),date('d',$tempOldTime),date('Y',$tempOldTime));
        $currExpTime = $oldTime;
        if($currentTime>$oldTime){
            $currExpTime = $currentTime;
        }
        $currentMonthEnd =  mktime(0,0,0,(date('m',$currExpTime)+1),1,date('Y',$currExpTime))-1;
        $endTime = mktime(0,0,0,(date('m',$currExpTime)+1+$month),1,date('Y',$currExpTime))-1;
        if($currentMonthEnd>$currExpTime){
            $endTime = $currentMonthEnd;
            if($month>1){
                $endTime = mktime(0,0,0,(date('m',$currExpTime)+$month),1,date('Y',$currExpTime))-1;
            }
        }
        return array('service_fee'=>0,'old_end_time'=>$tempOldTime,'new_start_time'=>$currExpTime+1,'new_end_time'=>$endTime,'curr_month_fee'=>0,'pre_month_fee'=>0);
    }

    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }
}
