<?php
namespace OSS;

use OSS\OssClient;
use OSS\Core\OssException;
use Our\SecretKeys;


/**
 * Class Common
 *
 * The Common class for 【Samples/*.php】 used to obtain OssClient instance and other common functions
 */
class Common
{
    const endpoint = \Our\SecretKeys::ossEndpoint;
    const accessKeyId = \Our\SecretKeys::ossAccessId;
    const accessKeySecret = \Our\SecretKeys::ossAccessKey;
    const bucket = \Our\SecretKeys::ossBucket;


    const endpointPre=SecretKeys::ossEndpointPre;
    const  buketPre=SecretKeys::ossBucket;

    public static function getOssClientOnline(){
        try {
            $ossClient = new OssClient(self::accessKeyId, self::accessKeySecret, self::endpoint, false);
        } catch (OssException $e) {
            printf(__FUNCTION__ . "creating OssClient instance: FAILED\n");
            printf($e->getMessage() . "\n");
            return null;
        }
        return $ossClient;
    }
    public static function getOssClientPre(){
        try {
            $ossClient = new OssClient(self::accessKeyId, self::accessKeySecret, self::endpointPre, false);
        } catch (OssException $e) {
            printf(__FUNCTION__ . "creating OssClient instance: FAILED\n");
            printf($e->getMessage() . "\n");
            return null;
        }
        return $ossClient;
    }
    /**
     * Get an OSSClient instance according to config.
     *
     * @return OssClient An OssClient instance
     */
    public static function getOssClient()
    {
        if(APP_ENV=='product' || APP_ENV=='productone'){
            return self::getOssClientOnline();
        }else{
            return self::getOssClientPre();
        }


    }

    public static function getBucketName()
    {
        if(APP_ENV=='product' || APP_ENV=='productone'){
            return self::bucket;
        }else{
            return self::buketPre;
        }

    }

    /**
     * A tool function which creates a bucket and exists the process if there are exceptions
     */
    public static function createBucket()
    {
        $ossClient = self::getOssClient();
        if (is_null($ossClient)) exit(1);
        $bucket = self::getBucketName();
        $acl = OssClient::OSS_ACL_TYPE_PUBLIC_READ;
        try {
            $ossClient->createBucket($bucket, $acl);
        } catch (OssException $e) {

            $message = $e->getMessage();
            if (\OSS\Core\OssUtil::startsWith($message, 'http status: 403')) {
                echo "Please Check your AccessKeyId and AccessKeySecret" . "\n";
                exit(0);
            } elseif (strpos($message, "BucketAlreadyExists") !== false) {
                echo "Bucket already exists. Please check whether the bucket belongs to you, or it was visited with correct endpoint. " . "\n";
                exit(0);
            }
            printf(__FUNCTION__ . ": FAILED\n");
            printf($e->getMessage() . "\n");
            return;
        }
        print(__FUNCTION__ . ": OK" . "\n");
    }

    public static function println($message)
    {
        if (!empty($message)) {
            echo strval($message) . "\n";
        }
    }
}

# Common::createBucket();
