<?php
/**
 * Sqlite 预定义了类 SQLiteDatabase 本实现没有使用。 
 * 这里使用的全部是过程函数。 
 * 无论是函数还是类，本实现只支持sqlite的2.x系列版本。 
 * php5.3新增扩展sqlite3用来支持3.x版本。 
 * PDO则同时支持2.x和3.x版本。
 */
class LtDbConnectionAdapterSqlite implements LtDbConnectionAdapter
{
	public function connect($connConf)
	{
		if (isset($connConf['pconnect']) && true == $connConf['pconnect'])
		{
			$func = 'sqlite_popen';
		} 
		else
		{
			$func = 'sqlite_open';
		} 
		$connConf["host"] = rtrim($connConf["host"], '\\/') . DIRECTORY_SEPARATOR;
		if(!is_dir($connConf["host"]))
		{
			if(!@mkdir($connConf["host"], 0777, true))
			{
				trigger_error("Can not create {$connConf['host']}");
			}
		}
		$error = '';
		$connResource = $func($connConf["host"] . $connConf["dbname"], 0666, $error);
		if (!$connResource)
		{
			trigger_error($error                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       