<?php

class AddressController extends \Our\Controller_AbstractApi {

    private $addressService ;
    public function init(){
        parent::init();
        $this->addressService = \Business\User\AddressServiceModel::getInstance();
    }

    /**
     * 获取单个地址
     */
    public function getAddressAction(){
        $address = $this->addressService->getMyAddress($this->req[\Our\NameConst::data],$this->memberId);
        if($address){
            if($address===true){
                $this->success(new stdClass(),\Our\DescribeConst::currentLatLngNoAddress,\Our\DescribeConst::currentLatLngNoAddress);
            }
            $this->success($address);
        }
        \Error\ErrorModel::throwException(\Error\CodeConfigModel::addressNotExist);
    }

    /**
     * 保存收货地址
     */
    public function saveAddressAction(){
        $result = $this->addressService->saveAddress($this->req[\Our\NameConst::data],$this->memberId);
        $this->success($result,\Our\DescribeConst::saveAddressSuccess,\Our\DescribeConst::saveAddressSuccess);
        if($result){
            $this->success(new stdClass(),\Our\DescribeConst::saveAddressSuccess,\Our\DescribeConst::saveAddressSuccess);
        }
        \Error\ErrorModel::throwException(\Error\CodeConfigModel::saveAddressFailed);
    }

    /**
     * 获取我的收货地址
     */
    public function getMyAddressesAction(){
        $addresses = $this->addressService->getMyAddresses($this->memberId);
        if($addresses){
            $this->success($addresses);
        }
        $this->success(array(),\Our\DescribeConst::emptyMyAddresses,\Our\DescribeConst::emptyMyAddresses);
    }

    /**
     * 删除单个地址
     * @throws Exception
     */
    public function delAddressAction(){
        $result = $this->addressService->delAddress($this->req[\Our\NameConst::data],$this->memberId);
        if($result){
            $this->success(array(),\Our\DescribeConst::delAddressSuccess,\Our\DescribeConst::delAddressSuccess);
        }
        \Error\ErrorModel::throwException(\Error\CodeConfigModel::delAddressFailed);
    }


    public function writeToFileAction(){
        $result = $this->addressService->writeToFile($this->req[\Our\NameConst::data],$this->memberId);
        if($result){
            $this->success(array());
        }
    }

}