<?php

namespace DAO;

class StoreMonthSalesModel extends \DAO\AbstractModel {



    protected function init(){

    }
    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_store_month_sales';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'id';




    /**
     * 店铺月销量
     *
     * @param $storeId
     * @return mixed
     */
    public function getStoreMonthSales($storeId){
        $this->setDb();
        $data =  $this->db->from('han_store_month_sales')->select('*')->where(array('store_id'=>$storeId))->fetchOne();

        if($data){
            return $data['num'];
        }
    }

    public function insertAllOrUpdate($datas){
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        $error = 0;
        $baseSql = "insert into {$this->_tableName}(store_id,num,updatetime) values";
        $insertAllSql = $baseSql;
        for ($i = 0; $i < count($datas); $i++) {
            $addSql = \Our\Common::format("({0},{1},{2}),", $datas[$i]['store_id'], $datas[$i]['num'], $datas[$i]['updatetime']);
            $insertAllSql .= $addSql;
            if ($i % 1000 == 0 && $i != 0) {
                $insertAllSql = rtrim($insertAllSql, ',');
                $insertAllSql .= 'ON DUPLICATE KEY UPDATE num = VALUES(num),updatetime=VALUES(updatetime)';
                $one = $this->db->insert()->query($insertAllSql);
                if ($one === false) {
                    $error++;
                }
                $insertAllSql = $baseSql;
            }
        }
        if ($insertAllSql != $baseSql) {
            $insertAllSql = rtrim($insertAllSql, ',');
            $insertAllSql .= 'ON DUPLICATE KEY UPDATE num = VALUES(num),updatetime=VALUES(updatetime)';
            $one = $this->db->insert($this->_tableName)->query($insertAllSql);
            if ($one === false) {
                $error++;
            }
        }
        if ($error > 0) {
            return false;
        }
        return true;
    }

    /**
     * 类实例
     *
     * @var \DAO\UserModel
     */
    private static $_instance = null;

    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance() {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }


}
