<?php
namespace DAO;
/**
 * User: liuyuzhen
 * Date: 2018/5/22
 * Time: 11:08
 * Description:
 */
class StoreMemberModel extends \DAO\AbstractModel{
    /**
     * 表名
     *
     * @var string
     */
    protected $_tableName = 'han_store_member';

    /**
     * 主键
     *
     * @var string
     */
    protected $_primaryKey = 'id';


    public function init(){

    }
    /**
     * 类实例
     *
     */
    private static $_instance = null;
    /**
     * 获取类实例
     *
     * @return \DAO\UserModel
     */
    public static function getInstance($dbName=\Our\DbNameConst::masterDBConnectName) {
        if (!(self::$_instance instanceof self)) {
            self::$_instance = new self($dbName);
        }

        return self::$_instance;
    }

    public function add($data){
        parent::setDb(\Our\DbNameConst::masterDBConnectName);
        $res=$this->db->insert($this->_tableName)->rows($data)->execute();
        return $res;
    }

    /**
     * 批量添加
     * @param $datas
     */
    public function addBatch($datas){
        parent::setDb(\Our\DbNameConst::masterDBConnectName);

        $sql = "INSERT INTO {$this->_tableName} ( store_id,member_id,type) values";
        foreach($datas as $key => $data){
            $sql .=\Our\Common::format(" (store_id={0} and member_id = {1} and type={2} ),",$data['storeId'],$data['memberId'],$data['type']);
        }
        $sql = trim($sql,',');
        $sql .= ";";
        $res = $this->db->insert($this->_tableName)->query($sql);
        return $res;
    }

    /**
     * 获取列表
     * @param $where
     * @param string $field
     * @return mixed
     */
    public function getList($where,$field = '*',$order = array('id','desc')){
        $this->setDb($this->dbName);
        $result = $this->db->select($field)->from($this->_tableName)->where($where)->order($order)->fetchAll();
        return $result;
    }

    public function del($where){
        $this->setDb(\Our\DbNameConst::masterDBConnectName);
        $result  = $this->db->delete($this->_tableName)->where($where)->execute();
        return $result;
    }


}