
<?php

use Error\ErrorModel;
use Error\CodeConfigModel;
use Our\NameConst;
use Our\Common;
use Business\User\MemberServiceModel;
use Business\Store\ShopkeeperServiceModel;


/**
 * 我是店主
 *
 * @date 2018-5-10
 * @author csw <993768343@qq.com>
 */
class DeliveryController extends \Our\Controller_AbstractClient {
    public $memberService;
    public $shopkeeperService;

    public function init(){
        parent::init();

    }
    /**
     * 选择配送员
     */
    public function selectDeliveryAction(){
        $deliveryService=\Business\Store\DeliveryServiceModel::getInstance();
        $data=$this->req['data'];
        $data['storeId']=$this->storeId;
        unset($data['key']);
        $result =$deliveryService->selectDeliveryMan($data);
        if($result!==false){
            $this->success($result,\Our\DescribeConst::successMessage,\Our\DescribeConst::successMessage);
        }
        ErrorModel::throwException(CodeConfigModel::commonError);
    }
    /**
     * 获得配送员列表
     */
    public function getDeliveriersAction(){
        $result = $this->shopkeeperService->getDiliveryManByStoreId($this->memberId);
        if($result!==false){
            $this->success($result,\Our\DescribeConst::successMessage,\Our\DescribeConst::successMessage);
        }
        ErrorModel::throwException(CodeConfigModel::commonError);
    }
    /**
     * 查询配送员
     *
     */
    public function searchDeliveryAction(){
        $shopkeeperService=\Business\Store\ShopkeeperServiceModel::getInstance();
        $res=$shopkeeperService->getDiliveryMan($this->req['data']['mobile']);
        $res=$res?$res:new \stdClass();
        $this->success($res,\Our\DescribeConst::successMessage);
    }
    /**
     * 添加配送员
     */
    public function addDeliveryAction(){
        $deliveryService=\Business\Store\DeliveryServiceModel::getInstance();
        $result =$deliveryService->addDeleiveryMan($this->storeId,$this->memberId);
        if($result!==false){
            $this->success($result,\Our\DescribeConst::successMessage,\Our\DescribeConst::successMessage);
        }
        ErrorModel::throwException(CodeConfigModel::commonError);
    }




}
